-- Create the location weighted version of the annual results by summing the results of the previous table
--  Add the results to the measure impacts table
SET search_path TO "MC_results_database";
DELETE FROM meas_impacts_wtd WHERE "BldgLoc" = 'IOU';
INSERT INTO meas_impacts_wtd
SELECT
"EnergyImpactID",
'DEER2020'::VARCHAR as "Version",
'D20v0'::VARCHAR as "VersionSource",
date_trunc('second', now()) as "LastMod",
"PA",
"BldgType"::VARCHAR,
"BldgVint"::VARCHAR,
'IOU'::VARCHAR as "BldgLoc",
"BldgHVAC"::VARCHAR,
"NormUnit"::VARCHAR,
(Sum("NumUnit") / Sum(wt_loc))::numeric(15,5) AS "NumUnit",
(Sum("MeasArea") / Sum(wt_loc))::numeric(15,1) AS "MeasArea",
"ScaleBasis"::VARCHAR,
(Sum("APreWBkWh") / Sum(wt_loc))::numeric(15,5) as "APreWBkWh",
(Sum("APreWBkW") / Sum(wt_loc))::numeric(15,5) as "APreWBkW",
(Sum("APreWBtherm") / Sum(wt_loc))::numeric(15,5) as "APreWBtherm",
(Sum("AStdWBkWh") / Sum(wt_loc))::numeric(15,5) as "AStdWBkWh",
(Sum("AStdWBkW") / Sum(wt_loc))::numeric(15,5) as "AStdWBkW",
(Sum("AStdWBtherm") / Sum(wt_loc))::numeric(15,5) as "AStdWBtherm"
from meas_impacts_tmp2
GROUP BY
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgHVAC",
"NormUnit",
"ScaleBasis"
ORDER BY 
"EnergyImpactID",
"PA",
"BldgType",
"BldgVint",
"BldgHVAC";
/*
ALTER TABLE "meas_impacts_wtd"
ALTER COLUMN "EnergyImpactID" SET NOT NULL,
ALTER COLUMN "PA" SET NOT NULL,
ALTER COLUMN "BldgType" SET NOT NULL,
ALTER COLUMN "BldgVint" SET NOT NULL,
ALTER COLUMN "BldgLoc" SET NOT NULL,
ALTER COLUMN "BldgHVAC" SET NOT NULL,
ADD PRIMARY KEY ("EnergyImpactID", "PA", "BldgType", "BldgVint", "BldgLoc", "BldgHVAC");
*/