/*
Navicat PGSQL Data Transfer

Source Server         : Local PostgresQL
Source Server Version : 90004
Source Host           : localhost:5432
Source Database       : deer_spt
Source Schema         : costeff

Target Server Type    : PGSQL
Target Server Version : 90004
File Encoding         : 65001

Date: 2011-11-29 19:36:40
*/


-- ----------------------------
-- Table structure for "costeff"."CostAdjust"
-- ----------------------------
DROP TABLE "costeff"."CostAdjust";
CREATE TABLE "costeff"."CostAdjust" (
"Index" int2 NOT NULL,
"Version" varchar(255) NOT NULL,
"VersionSrc" varchar(255),
"AdjustType" varchar(255) NOT NULL,
"Location" varchar(255) NOT NULL,
"MatlMult" numeric(8,3) NOT NULL,
"LaborMult" numeric(8,3) NOT NULL,
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of CostAdjust
-- ----------------------------
INSERT INTO "costeff"."CostAdjust" VALUES ('2', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ01', '1.000', '1.252', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('3', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ02', '1.000', '1.415', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('4', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ03', '1.000', '1.434', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('5', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ04', '1.000', '1.427', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('6', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ05', '1.000', '1.178', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('7', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ06', '1.000', '1.182', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('8', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ07', '1.000', '1.072', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('9', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ08', '1.000', '1.183', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('10', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ09', '1.000', '1.186', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('11', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ10', '1.000', '1.182', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('12', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ11', '1.000', '1.259', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('13', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ12', '1.000', '1.259', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('14', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ13', '1.000', '1.254', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('15', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ14', '1.000', '1.162', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('16', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ15', '1.000', '1.182', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('17', 'DEER2008', 'D08 v2.05', 'AP50', 'CZ16', '1.000', '1.214', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('18', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ01', '0.959', '1.126', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('19', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ02', '0.959', '1.465', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('20', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ03', '1.004', '1.478', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('21', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ04', '1.002', '1.352', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('22', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ05', '0.960', '1.067', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('23', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ06', '1.002', '1.076', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('24', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ07', '1.002', '1.061', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('25', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ08', '0.959', '1.067', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('26', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ09', '1.001', '1.075', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('27', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ10', '1.001', '1.076', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('28', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ11', '1.002', '1.083', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('29', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ12', '1.002', '1.100', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('30', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ13', '1.003', '1.158', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('31', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ14', '0.960', '1.040', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('32', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ15', '0.959', '1.067', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('33', 'DEER2008', 'D08 v2.05', 'DH50', 'CZ16', '0.960', '1.083', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('34', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ01', '0.989', '0.962', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('35', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ02', '0.939', '1.150', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('36', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ03', '1.027', '1.513', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('37', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ04', '1.024', '1.378', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('38', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ05', '0.880', '0.993', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('39', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ06', '0.870', '1.072', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('40', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ07', '1.000', '0.978', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('41', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ08', '0.936', '1.050', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('42', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ09', '0.963', '1.138', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('43', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ10', '0.904', '1.029', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('44', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ11', '0.984', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('45', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ12', '0.973', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('46', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ13', '0.894', '0.944', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('47', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ14', '0.879', '0.979', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('48', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ15', '0.936', '1.029', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('49', 'DEER2008', 'D08 v2.05', 'EL50', 'CZ16', '0.987', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('50', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ01', '0.989', '0.962', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('51', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ02', '0.939', '1.150', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('52', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ03', '1.027', '1.513', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('53', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ04', '1.024', '1.378', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('54', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ05', '0.880', '0.993', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('55', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ06', '0.870', '1.072', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('56', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ07', '1.000', '0.978', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('57', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ08', '0.936', '1.050', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('58', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ09', '0.963', '1.138', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('59', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ10', '0.904', '1.029', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('60', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ11', '0.984', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('61', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ12', '0.973', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('62', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ13', '0.894', '0.944', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('63', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ14', '0.879', '0.979', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('64', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ15', '0.936', '1.029', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('65', 'DEER2008', 'D08 v2.05', 'HVAC50', 'CZ16', '0.987', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('66', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ01', '0.999', '1.144', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('67', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ02', '0.999', '1.412', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('68', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ03', '1.000', '1.432', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('69', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ04', '1.000', '1.333', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('70', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ05', '0.999', '1.107', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('71', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ06', '1.000', '1.114', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('72', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ07', '1.000', '1.095', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('73', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ08', '0.999', '1.108', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('74', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ09', '1.000', '1.115', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('75', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ10', '1.000', '1.115', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('76', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ11', '1.000', '1.113', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('77', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ12', '1.000', '1.127', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('78', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ13', '1.000', '1.170', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('79', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ14', '0.999', '1.086', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('80', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ15', '0.999', '1.108', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('81', 'DEER2008', 'D08 v2.05', 'HZ50', 'CZ16', '0.999', '1.113', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('82', 'DEER2008', 'D08 v2.05', 'M50', 'CZ01', '0.989', '0.962', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('83', 'DEER2008', 'D08 v2.05', 'M50', 'CZ02', '0.939', '1.150', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('84', 'DEER2008', 'D08 v2.05', 'M50', 'CZ03', '1.027', '1.513', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('85', 'DEER2008', 'D08 v2.05', 'M50', 'CZ04', '1.024', '1.378', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('86', 'DEER2008', 'D08 v2.05', 'M50', 'CZ05', '0.880', '0.993', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('87', 'DEER2008', 'D08 v2.05', 'M50', 'CZ06', '0.870', '1.072', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('88', 'DEER2008', 'D08 v2.05', 'M50', 'CZ07', '1.000', '0.978', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('89', 'DEER2008', 'D08 v2.05', 'M50', 'CZ08', '0.936', '1.050', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('90', 'DEER2008', 'D08 v2.05', 'M50', 'CZ09', '0.963', '1.138', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('91', 'DEER2008', 'D08 v2.05', 'M50', 'CZ10', '0.904', '1.029', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('92', 'DEER2008', 'D08 v2.05', 'M50', 'CZ11', '0.984', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('93', 'DEER2008', 'D08 v2.05', 'M50', 'CZ12', '0.973', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('94', 'DEER2008', 'D08 v2.05', 'M50', 'CZ13', '0.894', '0.944', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('95', 'DEER2008', 'D08 v2.05', 'M50', 'CZ14', '0.879', '0.979', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('96', 'DEER2008', 'D08 v2.05', 'M50', 'CZ15', '0.936', '1.029', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('97', 'DEER2008', 'D08 v2.05', 'M50', 'CZ16', '0.987', '1.048', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('1', 'DEER2008', 'D08 v2.05', 'None', 'All', '1.000', '1.000', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('98', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ01', '0.959', '1.126', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('99', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ02', '0.959', '1.465', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('100', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ03', '1.004', '1.478', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('101', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ04', '1.002', '1.352', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('102', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ05', '0.960', '1.067', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('103', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ06', '1.002', '1.076', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('104', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ07', '1.002', '1.061', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('105', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ08', '0.959', '1.067', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('106', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ09', '1.001', '1.075', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('107', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ10', '1.001', '1.076', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('108', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ11', '1.002', '1.083', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('109', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ12', '1.002', '1.100', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('110', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ13', '1.003', '1.158', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('111', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ14', '0.960', '1.040', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('112', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ15', '0.959', '1.067', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('113', 'DEER2008', 'D08 v2.05', 'PL50', 'CZ16', '0.960', '1.083', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('114', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ01', '0.999', '1.144', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('115', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ02', '0.999', '1.412', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('116', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ03', '1.000', '1.432', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('117', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ04', '1.000', '1.333', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('118', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ05', '0.999', '1.107', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('119', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ06', '1.000', '1.114', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('120', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ07', '1.000', '1.095', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('121', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ08', '0.999', '1.108', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('122', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ09', '1.000', '1.115', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('123', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ10', '1.000', '1.115', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('124', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ11', '1.000', '1.113', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('125', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ12', '1.000', '1.127', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('126', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ13', '1.000', '1.170', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('127', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ14', '0.999', '1.086', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('128', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ15', '0.999', '1.108', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('129', 'DEER2008', 'D08 v2.05', 'SH50', 'CZ16', '0.999', '1.113', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('130', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ01', '1.000', '1.252', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('131', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ02', '1.000', '1.415', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('132', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ03', '1.000', '1.434', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('133', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ04', '1.000', '1.427', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('134', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ05', '1.000', '1.178', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('135', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ06', '1.000', '1.182', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('136', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ07', '1.000', '1.072', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('137', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ08', '1.000', '1.183', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('138', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ09', '1.000', '1.186', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('139', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ10', '1.000', '1.182', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('140', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ11', '1.000', '1.259', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('141', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ12', '1.000', '1.259', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('142', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ13', '1.000', '1.254', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('143', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ14', '1.000', '1.162', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('144', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ15', '1.000', '1.182', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('145', 'DEER2008', 'D08 v2.05', 'SWH50', 'CZ16', '1.000', '1.214', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('146', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ01', '1.031', '1.110', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('147', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ02', '1.007', '1.327', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('148', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ03', '1.102', '1.331', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('149', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ04', '0.939', '1.329', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('150', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ05', '0.998', '1.134', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('151', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ06', '1.018', '1.162', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('152', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ07', '1.033', '1.087', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('153', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ08', '0.989', '1.161', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('154', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ09', '0.952', '1.160', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('155', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ10', '1.028', '1.161', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('156', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ11', '1.033', '1.201', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('157', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ12', '1.189', '1.202', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('158', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ13', '1.036', '1.181', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('159', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ14', '0.975', '1.126', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('160', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ15', '0.997', '1.161', null);
INSERT INTO "costeff"."CostAdjust" VALUES ('161', 'DEER2008', 'D08 v2.05', 'WI50', 'CZ16', '1.032', '1.174', null);

-- ----------------------------
-- Table structure for "costeff"."CostAdjustType"
-- ----------------------------
DROP TABLE "costeff"."CostAdjustType";
CREATE TABLE "costeff"."CostAdjustType" (
"Index" int2 NOT NULL,
"Code" varchar(255) NOT NULL,
"Description" varchar(255) NOT NULL,
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of CostAdjustType
-- ----------------------------
INSERT INTO "costeff"."CostAdjustType" VALUES ('1', 'None', 'no location cost adjustment', 'default value if not specified');
INSERT INTO "costeff"."CostAdjustType" VALUES ('2', 'AP50', 'for Appliance measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('3', 'DH50', 'for Domestic Hot Water measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('4', 'EL50', 'for Lighting and other Electrical measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('5', 'HVAC50', 'for HVAC measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('6', 'HZ50', 'TBD (never referenced in DEER cost data)', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('7', 'M50', 'for Motor measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('8', 'PL50', 'for Plumbing measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('9', 'SH50', 'for Shell measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('10', 'SWH50', 'for Service Water Heating measures', '');
INSERT INTO "costeff"."CostAdjustType" VALUES ('11', 'WI50', 'for Window measures', '');

-- ----------------------------
-- Table structure for "costeff"."CostQualifier"
-- ----------------------------
DROP TABLE "costeff"."CostQualifier";
CREATE TABLE "costeff"."CostQualifier" (
"Code" varchar(255) NOT NULL,
"Description" varchar(255),
"Comment" varchar(255),
"Index" int2
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of CostQualifier
-- ----------------------------
INSERT INTO "costeff"."CostQualifier" VALUES ('DirectInstall', 'Direct Install', '', '2');
INSERT INTO "costeff"."CostQualifier" VALUES ('Down1pack', 'single lamp per unit', 'for downstream CFL implementations', '5');
INSERT INTO "costeff"."CostQualifier" VALUES ('Down2to3pack', 'packaged with 2 or 3 lamps per unit', 'for downstream CFL implementations', '3');
INSERT INTO "costeff"."CostQualifier" VALUES ('Down4to6pack', 'packaged with 4 or 6 lamps per unit', 'for downstream CFL implementations', '4');
INSERT INTO "costeff"."CostQualifier" VALUES ('Downstream', 'Downstream', '', '6');
INSERT INTO "costeff"."CostQualifier" VALUES ('None', 'no cost qualifier used', 'default value if not specified', '1');
INSERT INTO "costeff"."CostQualifier" VALUES ('Up1pack', 'single lamp per unit', 'for upstream CFL implementations', '9');
INSERT INTO "costeff"."CostQualifier" VALUES ('Up2to3pack', 'packaged with 2 or 3 lamps per unit', 'for upstream CFL implementations', '7');
INSERT INTO "costeff"."CostQualifier" VALUES ('Up4to6pack', 'packaged with 4 or 6 lamps per unit', 'for upstream CFL implementations', '8');
INSERT INTO "costeff"."CostQualifier" VALUES ('Upstream', 'Upstream', '', '10');

-- ----------------------------
-- Table structure for "costeff"."CostRecType"
-- ----------------------------
DROP TABLE "costeff"."CostRecType";
CREATE TABLE "costeff"."CostRecType" (
"Index" int2 NOT NULL,
"Code" varchar(255) NOT NULL,
"Description" varchar(255) NOT NULL,
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of CostRecType
-- ----------------------------
INSERT INTO "costeff"."CostRecType" VALUES ('1', 'FullCost', 'cost record is the full cost of the associated technology', null);
INSERT INTO "costeff"."CostRecType" VALUES ('2', 'IncrementalCost', 'cost record is the incremental cost associated with the measure', '');

-- ----------------------------
-- Table structure for "costeff"."EUL"
-- ----------------------------
DROP TABLE "costeff"."EUL";
CREATE TABLE "costeff"."EUL" (
"Index" int2 NOT NULL,
"EUL_ID" varchar(255) NOT NULL,
"Description" varchar(255),
"Version" varchar(255) NOT NULL,
"VersionSrc" varchar(255),
"LastMod" timestamp(6),
"Sector" varchar(255),
"UseCategory" varchar(255),
"UseSubCat" varchar(255),
"TechGroup" varchar(255),
"TechType" varchar(255),
"BldgType" varchar(255) NOT NULL,
"BldgLoc" varchar(255) NOT NULL,
"BasisType" varchar(255),
"BasisValue" numeric(8,2),
"BasisDegFactor" numeric(8,3),
"defEFLH" numeric(8,1),
"EUL_Max_Yrs" numeric(8,2),
"EUL_Yrs" numeric(8,2),
"RUL_Yrs" numeric(8,2),
"Comment" varchar(255),
"Status" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of EUL
-- ----------------------------
INSERT INTO "costeff"."EUL" VALUES ('1', 'Agr-DripIrr', 'Sprinkler to Drip/Micro Irrigation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'Irrigate', 'Irr-FrmIrr', 'Irrigate', 'IrrigSys', 'Ag', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('2', 'Agr-GHC', 'Greenhouse Heat Curtain', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'ProcHeat', 'ProcHeat-ESD', 'SpaceHtg_eq', '', 'Ag', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('3', 'Agr-Irfilm', 'Infrared Film for Greenhouses', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'BldgEnv', 'Env-Fen', 'Fenest', 'WinFilm', 'Ag', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('4', 'Agr-LPSNperm', 'Low Pressure Sprinkler Nozzles (permanent)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'Irrigate', 'Irr-FrmIrr', 'Irrigate', 'IrrigSys', 'Ag', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('5', 'Agr-LPSNport', 'Low Pressure Sprinkler Nozzles (portable)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'Irrigate', 'Irr-FrmIrr', 'Irrigate', 'IrrigSys', 'Ag', 'Any', 'rated years', null, null, null, null, '3.00', '1.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('6', 'Agr-MilkPreCool', 'Milk Pre-Cooler', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'ProcRefrig', 'ProcRef-ProdChl', '', '', 'Ag', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('7', 'Agr-VSDmilkTrnsfr', 'Milk Transfer Pump Variable Speed Drive', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'ProcDist', 'ProcDist-Pmp', 'Motor_Spd', 'ASD', 'Ag', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('8', 'Agr-VSDmilkVcm', 'Milking Vacuum Pump Variable Speed Drive', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'ProcDist', 'ProcDist-Pmp', 'Motor_Spd', 'ASD', 'Ag', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('9', 'Agr-VSDWellPmp', 'Well Pump Variable Speed Drive', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'Irrigate', 'Irr-FrmIrr', 'Motor_Spd', 'ASD', 'Ag', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('10', 'Agr-WineTnkIns', 'Wine Tank Insulation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Ag', 'ProcRefrig', 'ProcRef-ProdChl', 'Chiller', 'TankIns', 'Ag', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('11', 'Appl-EffCW', 'High Efficiency Clothes Washer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Aplg', 'APlg-Lndry', 'Clean_equip', 'ClothesWash', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('12', 'Appl-EffDW', 'High Efficiency Dishwasher', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Aplg', 'APlg-KitAp', 'Clean_equip', 'DishWash', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('13', 'Appl-ESFrzr', 'High Efficiency Freezer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Aplg', 'APlg-KitAp', 'Refrig_Stor', 'Freezer', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('14', 'Appl-ESRefg', 'High Efficiency Refrigerator', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Aplg', 'APlg-KitAp', 'Refrig_Stor', 'Refrig', 'Res', 'Any', 'rated years', null, null, null, null, '14.00', '4.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('15', 'Appl-RecFrzr', 'Freezer Recycling (RUL)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Aplg', 'APlg-KitAp', 'Refrig_Stor', 'Freezer', 'Res', 'Any', 'rated years', null, null, null, null, null, '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('16', 'Appl-RecRef', 'Refrigerator Recycling (RUL)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Aplg', 'APlg-KitAp', 'Refrig_Stor', 'Refrig', 'Res', 'Any', 'rated years', null, null, null, null, null, '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('17', 'BldgEnv-CoolRoof', 'Cool Roof', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Opaq', 'BldgShell', 'CoolRoof', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('18', 'BldgEnv-FlrIns', 'Floor Insulation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Opaq', 'BldgShell', 'FloorIns', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('19', 'BldgEnv-RoofIns', 'Roof/Ceiling Insulation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('20', 'BS-BlowInIns', 'Wall Insulation (blown-in)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', 'WallBlowIns', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('21', 'BS-CeilIns', 'Roof/Ceiling Insulation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('22', 'BS-CoolAttic', 'Cool Attic', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('23', 'BS-FlrIns', 'Floor Insulation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', 'FloorIns', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('24', 'BS-LtRoof', 'Cool Roof', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', 'CoolRoof', 'Res', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('25', 'BS-LtWalls', 'Light Colored Exterior Walls', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'Res', 'Any', 'rated years', null, null, null, null, '6.00', '2.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('26', 'BS-WallIns', 'Wall Insulation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('27', 'BS-Win', 'High Performance Windows', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Fen', 'Fenest', '', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('28', 'BS-WinFilm', 'Reflective Window Films & Sunscreens', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Fen', 'Fenest', 'WinFilm', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('29', 'BS-Wthr', 'Low-Income Weatherization', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('30', 'BS-WthrEvap', 'Low-Income Weatherization w/Evaporative Cooler', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('31', 'ComLau-EffCW', 'High Efficiency Clothes Washer (CEE Tiers 1,2,3)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Aplg', 'APlg-Lndry', 'Clean_equip', 'ClothesWash', 'Com', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('32', 'Cook-ElecCombOven', 'Combination Oven', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'OvenComb', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('33', 'Cook-ElecConvOven', 'Convection Ovens', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'OvenConv', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('34', 'Cook-ElecFryer', 'Electric Fryer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Fryer', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('35', 'Cook-ElecGriddle', 'Griddle', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Griddle', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('36', 'Cook-ElecStmCooker', 'Steam Cooker (electric)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Steamer', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('37', 'Cook-GasCombOVen', 'Combination Oven', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'OvenComb', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('38', 'Cook-GasConvOven', 'Convection Ovens', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'OvenConv', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('39', 'Cook-GasFryer', 'Gas Fryer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Fryer', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('40', 'Cook-GasGriddle', 'Griddle', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Griddle', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('41', 'Cook-GasRackOven', 'Commercial Gas Rack Ovens', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'OvenRack', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('42', 'Cook-GasStmCooker', 'Steam Cooker (gas)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Steamer', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('43', 'Cook-GDRef', 'Commercial Reach-In Refrigerator / Freezer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'ProcRef-ProdStor', 'Refrig_Stor', 'ReachIn', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('44', 'Cook-HoldCab', 'Commercial Insulated Holding Cabinet', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'FsServ', 'HoldBin', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('45', 'Cook-IceMach', 'Ice Machine', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'ProcRef-ProdChl', 'Refrig_Self', 'IceMach', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('46', 'Cook-SDFreez', 'Commercial Reach-In Refrigerator / Freezer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'ProcRef-ProdStor', 'Refrig_Stor', 'ReachIn', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('47', 'Cook-SDRef', 'Commercial Reach-In Refrigerator / Freezer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'ProcRef-ProdStor', 'Refrig_Stor', 'ReachIn', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('48', 'Cook-VatFryer', 'Vat Fryer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'FoodServ', 'Food-Cook', 'Cook_Equip', 'Fryer', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('49', 'GlazDaylt-Dayltg', 'Daylighting - controls', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg_Ctls', 'Ltg_Wired', 'LtSensor', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('50', 'GlazDaylt-HPWinDaylt', 'High Performance Windows for Daylighting', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Fen', 'Fenest', '', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('51', 'GlazDaylt-LoSHGC', 'Low Solar Heat Gain Coefficient Windows', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Fen', 'Fenest', '', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('52', 'GlazDaylt-WinFilm', 'Reflective Window Films & Sunscreens', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Fen', 'Fenest', 'WinFilm', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('53', 'GrocDisp-ASH', 'Anti-Sweat Heat (ASH) Controls', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Disp', 'Refrig_Tech', 'RefrigCtls', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('54', 'GrocDisp-DispCvrs', 'Night Covers for vertical and horizontal refrigerated display cases', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Disp', 'Refrig_Stor', 'Disp-DGC', 'Com', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('55', 'GrocDisp-DispLtgCtrl', 'Display Case Lighting Control', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtRDC', 'Refrig_Stor', 'RefrigLtg', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('56', 'GrocDisp-FEvapFanMtr', 'High Efficiency Evaporator Fan Motors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Equ', 'Refrig_Stor', 'RefrigEquip', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('57', 'GrocDisp-FixtDoors', 'New case with Doors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Disp', 'Refrig_Stor', 'multiple technologies', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('58', 'GrocDisp-FixtDrGask', 'Door Gaskets on Cooler/Freezer Doors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Disp', 'Refrig_Stor', 'Disp-DGC', 'Com', 'Any', 'rated years', null, null, null, null, '4.00', '1.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('59', 'GrocDisp-FixtLtg-LED', 'Display Case Lighting LED Lighting', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtRDC', 'Refrig_Stor', 'RefrigLtg', 'Com', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('60', 'GrocDisp-ZeroHtDrs', 'Zero Heat Reach-in Glass Doors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Disp', 'Refrig_Stor', 'Disp-DGC', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('61', 'GrocSys-Cndsr', 'Refrigerator Upgrades (Condenser)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Equ', 'Refrig_Tech', 'RefrigEquip', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('62', 'GrocSys-FltHdPres', 'Refrigerator Upgrades (Head Pressure)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Equ', 'Refrig_Tech', 'RefrigCtls', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('63', 'GrocSys-FltSucPres', 'Refrigerator Upgrades (Suction Pressure)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Equ', 'Refrig_Tech', 'RefrigCtls', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('64', 'GrocSys-HtRecov', 'Heat Recovery from Central Refrigeration System', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Equ', 'Refrig_Tech', 'RefrigEquip', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('65', 'GrocSys-MechSubcl', 'Refrigerator Upgrades (Subcooling)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Equ', 'Refrig_Tech', 'RefrigEquip', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('66', 'GrocSys-Retro', 'Retrocommissioning', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('67', 'GrocWlkIn-DrClsr', 'Auto-Closer for Walk-In Cooler/Freezer Doors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Stor', 'Disp-DGC', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('68', 'GrocWlkIn-StripCrtn', 'Strip Curtains for Walk-Ins', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Stor', 'StripCurt', 'Com', 'Any', 'rated years', null, null, null, null, '4.00', '1.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('69', 'GrocWlkIn-WDrGask', 'Door Gaskets on Cooler/Freezer Doors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Stor', 'Disp-DGC', 'Com', 'Any', 'rated years', null, null, null, null, '4.00', '1.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('70', 'GrocWlkIn-WEvapFanMtr', 'High Efficiency Evaporator Fan Motors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Tech', 'RefrigEquip', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('71', 'GrocWlkIn-WEvapFMtrCtrl', 'Evaporator Fan Controller for Walk-In Coolers', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Stor', 'RefrigCtls', 'Com', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('108', 'HV-DuctSeal', 'Duct Sealing', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-Vent', 'HV_AirDist', 'DuctSysR', 'Res', 'Any', 'rated years', null, null, null, null, '18.00', '6.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('109', 'HV-EffFurn', 'High Efficiency Furnace', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpHt', 'SpaceHtg_eq', 'GasFurnace', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('110', 'HV-Evap', 'Evaporative Cooler', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'EvapCool', 'ResEvap', 'Res', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('111', 'HV-MFRefChrg', 'Refrigerant Charge', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxAC_equip', 'refrig', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('112', 'HV-MHRefChrg', 'Refrigerant Charge', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxAC_equip', 'refrig', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('113', 'HV-ProgTstat', 'Programmable Thermostat', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'Tstat', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('114', 'HV-RAC-ES', 'Room AC - Energy Star', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Res', 'Any', 'rated years', null, null, null, null, '9.00', '3.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('115', 'HV-RAC-RUL', 'Room AC - Recycling (RUL)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Res', 'Any', 'rated years', null, null, null, null, null, '3.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('116', 'HV-RefChrg', 'Refrigerant Charge', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxAC_equip', 'refrig', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('117', 'HV-ResAC', 'High Efficiency Air Conditioner (package and split systems)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Res', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('118', 'HV-ResAC-CleanCoil', 'Clean Condenser Coils', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtRej', 'HtRej', 'CondCoil', 'Res', 'Any', 'rated years', null, null, null, null, '3.00', '1.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('119', 'HV-ResEvapAC', 'High Efficiency Air Conditioner (Evap cooled split systems)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'EvapCool', 'ResEvap', 'Res', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('120', 'HV-ResHP', 'High Efficiency Heat Pump', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', '', 'Res', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('121', 'HV-SFRefChrg', 'Refrigerant Charge', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxAC_equip', 'refrig', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('122', 'HV-WHfan', 'Whole House Fans', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-Vent', 'HV_AirDist', '', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('72', 'HVAC-2Spd', 'Two-Speed Fan', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'HV_AirDist', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('73', 'HVAC-addEcono', 'Add Economizer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'HV_AirDist', 'AirEcono', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('74', 'HVAC-airAC', 'Air Conditioners (split and unitary)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('75', 'HVAC-airHP', 'Heat Pumps (split and unitary)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('76', 'HVAC-AtoAHtExchng', 'Air To Air Heat Exchanger', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'HV_AirDist', 'HeatExchanger', 'Com', 'Any', 'rated years', null, null, null, null, '14.00', '4.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('77', 'HVAC-Blr', 'High Efficiency Boiler ', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpHt', 'SpaceHtg_eq', '', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('78', 'HVAC-Chlr', 'High Efficiency Chillers', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'Chiller', '', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('79', 'HVAC-ChlrComp', 'Compressor Heat Recovery (w/electric water heating)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', '', 'WaterHtg_eq', '', 'Com', 'Any', 'rated years', null, null, null, null, '14.00', '4.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('80', 'HVAC-ClnCondCoils', 'Clean Condenser Coils', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtRej', 'HtRej', 'CondCoil', 'Com', 'Any', 'rated years', null, null, null, null, '3.00', '1.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('81', 'HVAC-ClTwrPkgSys', 'Cooling Tower for Packaged System', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtRej', 'HtRej', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('82', 'HVAC-DuctInsul', 'Duct Insulation Material', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'HV_AirDist', 'DuctInsC', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('83', 'HVAC-DuctSeal', 'Duct Sealing - Single Zone Package System', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'HV_AirDist', 'DuctSysC', 'Com', 'Any', 'rated years', null, null, null, null, '18.00', '6.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('84', 'HVAC-EMS', 'Energy Management System', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'EMS', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('85', 'HVAC-evapAC', 'Air Conditioners (split and unitary)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('86', 'HVAC-EvapCool', 'Evap Cool  Indirect', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'EvapCool', 'ComEvap', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('87', 'HVAC-FanPwrdMix', 'Fan Powered Mixing Boxes', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'HV_AirDist', '', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('88', 'HVAC-Frnc', 'High Efficiency Furnace', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpHt', 'SpaceHtg_eq', 'GasFurnace', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('89', 'HVAC-HydHPVarFlow', 'Hydronic Heat Pump Var Flow Valve', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('90', 'HVAC-ProgTStats', 'Setback Programmable Thermostats', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'Tstat', 'Com', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('91', 'HVAC-PTAC', 'Air Conditioners (split and unitary)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('513', 'HVAC-PTACCtrl', 'Package Terminal AC - Controller', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'HV_Tech', 'TStat', 'Gst', 'PGE', 'rated years', null, null, null, null, '15.00', null, '', 'Proposed');
INSERT INTO "costeff"."EUL" VALUES ('514', 'HVAC-PTACCtrl', 'Package Terminal AC - Controller', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'HV_Tech', 'TStat', 'Htl', 'PGE', 'rated years', null, null, null, null, '15.00', null, '', 'Proposed');
INSERT INTO "costeff"."EUL" VALUES ('515', 'HVAC-PTACCtrl', 'Package Terminal AC - Controller', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'HV_Tech', 'TStat', 'Mtl', 'PGE', 'rated years', null, null, null, null, '15.00', null, '', 'Proposed');
INSERT INTO "costeff"."EUL" VALUES ('92', 'HVAC-PTHP', 'Heat Pumps (split and unitary)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('93', 'HVAC-RedcOverVent', 'Reducing Overventilation', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'HV_AirDist', '', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('94', 'HVAC-RefChg', 'Refrigerant Charge', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'dxAC_equip', 'refrig', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('95', 'HVAC-repEcono', 'Repair Economizer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'HV_AirDist', 'AirEcono', 'Com', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('96', 'HVAC-Reset', 'Water Loop Reset', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-EnvCtls', 'LiqCirc', 'TempReset', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('97', 'HVAC-RotHtRecov', 'Rotary Heat Recovery', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'HV_AirDist', 'HeatRecov', 'Com', 'Any', 'rated years', null, null, null, null, '14.00', '4.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('98', 'HVAC-StmTrp', 'Steam Traps', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpHt', 'SteamCirc', 'Steam Trap', 'Com', 'Any', 'rated years', null, null, null, null, '6.00', '2.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('99', 'HVAC-Timeclocks', 'Time Clocks (heating/cooling)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'Timer', 'Com', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('100', 'HVAC-VarFlow', 'Hydronic Heat Pump Var Flow Valve', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'LiqCirc', 'FlowCtrlWater', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('101', 'HVAC-VAVBox', 'Variable Air Volume Box, VSD Fan', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'Motor_Spd', 'ASD', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('102', 'HVAC-VSD-fan', 'Variable Air Volume Box, VSD Fan', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'Motor_Spd', 'ASD', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('103', 'HVAC-VSD-pump', 'Variable Flow Water Loop, VSD Pump', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'Motor_Spd', 'ASD', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('104', 'HVAC-VSDSupFan', 'VSD Supply Fan Motors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'Motor_Spd', 'ASD', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('105', 'HVAC-WSHP', 'High Efficiency Water Source Heat Pump', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('106', 'HVAC-wtrAC', 'Air Conditioners (split and unitary)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('107', 'HVAC-WtrEcon', 'Water Side Economizer', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-SpCl', 'HtRej', 'WSEcono', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('123', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'lamp rated hours', '10000.00', '1.000', '2978.8', '15.00', '3.36', '1.12', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('124', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Asm', 'Any', 'lamp rated hours', '10000.00', '1.000', '2300.0', '15.00', '4.35', '1.45', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('125', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'ECC', 'Any', 'lamp rated hours', '10000.00', '1.000', '2420.0', '15.00', '4.13', '1.38', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('126', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'EPr', 'Any', 'lamp rated hours', '10000.00', '1.000', '2240.0', '15.00', '4.46', '1.49', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('127', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'ERC', 'Any', 'lamp rated hours', '10000.00', '1.000', '2600.0', '15.00', '3.85', '1.28', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('128', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'ESe', 'Any', 'lamp rated hours', '10000.00', '1.000', '2330.0', '15.00', '4.29', '1.43', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('129', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'EUn', 'Any', 'lamp rated hours', '10000.00', '1.000', '2370.0', '15.00', '4.22', '1.41', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('130', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Gro', 'Any', 'lamp rated hours', '10000.00', '1.000', '3890.0', '15.00', '2.57', '0.86', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('131', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Hsp', 'Any', 'lamp rated hours', '10000.00', '1.000', '4200.0', '15.00', '2.38', '0.79', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('132', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Htl', 'Any', 'lamp rated hours', '10000.00', '1.000', '1670.0', '15.00', '5.99', '2.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('133', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'MBT', 'Any', 'lamp rated hours', '10000.00', '1.000', '3090.0', '15.00', '3.24', '1.08', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('134', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'MLI', 'Any', 'lamp rated hours', '10000.00', '1.000', '2580.0', '15.00', '3.88', '1.29', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('135', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Mtl', 'Any', 'lamp rated hours', '10000.00', '1.000', '1370.0', '15.00', '7.30', '2.43', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('136', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Nrs', 'Any', 'lamp rated hours', '10000.00', '1.000', '3570.0', '15.00', '2.80', '0.93', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('137', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'OfL', 'Any', 'lamp rated hours', '10000.00', '1.000', '3000.0', '15.00', '3.33', '1.11', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('138', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'OfS', 'Any', 'lamp rated hours', '10000.00', '1.000', '2980.0', '15.00', '3.36', '1.12', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('147', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Res', 'Any', 'lamp rated hours', '10000.00', '0.500', '795.7', '15.00', '6.28', '2.09', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('139', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RFF', 'Any', 'lamp rated hours', '10000.00', '1.000', '4810.0', '15.00', '2.08', '0.69', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('140', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RSD', 'Any', 'lamp rated hours', '10000.00', '1.000', '4830.0', '15.00', '2.07', '0.69', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('141', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Rt3', 'Any', 'lamp rated hours', '10000.00', '1.000', '3710.0', '15.00', '2.70', '0.90', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('142', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RtL', 'Any', 'lamp rated hours', '10000.00', '1.000', '4350.0', '15.00', '2.30', '0.77', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('143', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RtS', 'Any', 'lamp rated hours', '10000.00', '1.000', '4010.0', '15.00', '2.49', '0.83', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('144', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'SCn', 'Any', 'lamp rated hours', '10000.00', '1.000', '2760.0', '15.00', '3.62', '1.21', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('145', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'SUn', 'Any', 'lamp rated hours', '10000.00', '1.000', '2760.0', '15.00', '3.62', '1.21', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('146', 'ILtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'WRf', 'Any', 'lamp rated hours', '10000.00', '1.000', '4730.0', '15.00', '2.11', '0.70', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('148', 'ILtg-CFLfix', 'CFL Fixtures', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'CFL_fixt', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('149', 'ILtg-CFLfix', 'CFL Fixtures', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'CFL_fixt', 'Res', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('150', 'ILtg-Exit', 'Exit Lighting', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtExit', 'Ltg_Wired', 'Exit_fixt', 'Com', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('151', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2978.8', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('152', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2630.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('153', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2430.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('154', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('155', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2480.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('156', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2290.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('157', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('158', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4900.0', '15.00', '14.29', '4.76', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('159', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '5230.0', '15.00', '13.38', '4.46', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('160', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1950.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('161', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3510.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('162', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3220.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('163', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1570.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('164', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('165', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2640.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('166', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2590.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('167', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4840.0', '15.00', '14.46', '4.82', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('168', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4830.0', '15.00', '14.49', '4.83', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('169', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('170', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4260.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('171', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3380.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('172', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('173', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('174', 'ILtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4760.0', '15.00', '14.71', '4.90', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('175', 'ILtg-LED', '0.3 W LED Night Light', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg_ILtTsk', 'Ltg_Plugin', 'Fixture', 'Res', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('176', 'ILtg-LED-seas', 'LED Seasonal Light', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg_SLt', 'Ltg_Plugin', 'Seasonal', 'Res', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('177', 'ILtg-Lfluor-CommArea', 'Linear Fluorescents - MF Common Area', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MFM', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', null, '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('178', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3141.5', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('179', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2630.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('180', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2430.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('181', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('182', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2480.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('183', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2290.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('184', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('185', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4900.0', '15.00', '14.29', '4.76', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('186', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '5230.0', '15.00', '13.38', '4.46', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('187', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1950.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('188', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3510.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('189', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3220.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('190', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1570.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('191', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('192', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2640.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('193', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2590.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('202', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Res', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '795.7', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('194', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4840.0', '15.00', '14.46', '4.82', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('195', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4830.0', '15.00', '14.49', '4.83', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('196', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('197', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4260.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('198', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3380.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('199', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('200', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('201', 'ILtg-Lfluor-Elec', 'Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4760.0', '15.00', '14.71', '4.90', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('203', 'ILtg-Lfluor-fix', 'Linear Fluorescent - Fixtures', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Com', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('204', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3141.5', '15.00', '14.32', '4.77', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('205', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2630.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('206', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2430.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('207', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('208', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2480.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('209', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2290.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('210', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('211', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4900.0', '15.00', '9.18', '3.06', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('212', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '5230.0', '15.00', '8.60', '2.87', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('213', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '1950.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('214', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3510.0', '15.00', '12.82', '4.27', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('215', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3220.0', '15.00', '13.98', '4.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('216', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '1570.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('217', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4140.0', '15.00', '10.87', '3.62', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('218', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2640.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('219', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '2590.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('228', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Res', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', null, '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('220', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4840.0', '15.00', '9.30', '3.10', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('221', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4830.0', '15.00', '9.32', '3.11', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('222', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3370.0', '15.00', '13.35', '4.45', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('223', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4260.0', '15.00', '10.56', '3.52', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('224', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3380.0', '15.00', '13.31', '4.44', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('225', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3420.0', '15.00', '13.16', '4.39', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('226', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '3420.0', '15.00', '13.16', '4.39', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('227', 'ILtg-Lfluor-Mag', 'Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4760.0', '15.00', '9.45', '3.15', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('229', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3141.5', '15.00', '6.37', '1.12', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('230', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2630.0', '15.00', '7.60', '1.53', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('231', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2430.0', '15.00', '8.23', '1.74', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('232', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2140.0', '15.00', '9.35', '2.12', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('233', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2480.0', '15.00', '8.06', '1.69', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('234', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2290.0', '15.00', '8.73', '1.91', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('235', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2370.0', '15.00', '8.44', '1.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('236', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '4900.0', '15.00', '4.08', '0.36', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('237', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '5230.0', '15.00', '3.82', '0.27', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('238', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '1950.0', '15.00', '10.26', '2.42', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('239', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3510.0', '15.00', '5.70', '0.90', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('240', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3220.0', '15.00', '6.21', '1.07', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('241', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '1570.0', '15.00', '12.74', '3.25', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('242', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '4140.0', '15.00', '4.83', '0.61', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('243', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2640.0', '15.00', '7.58', '1.53', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('244', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '2590.0', '15.00', '7.72', '1.57', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('253', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Res', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', null, '11.00', '11.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('245', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '4840.0', '15.00', '4.13', '0.38', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('246', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '4830.0', '15.00', '4.14', '0.38', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('247', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3370.0', '15.00', '5.93', '0.98', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('248', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '4260.0', '15.00', '4.69', '0.56', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('249', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3380.0', '15.00', '5.92', '0.97', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('250', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3420.0', '15.00', '5.85', '0.95', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('251', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '3420.0', '15.00', '5.85', '0.95', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('252', 'ILtg-Lfluor-T12Mag', 'Linear Fluorescent with T12 Lamp + Magnetic Ballast', 'DEER2011', 'D11 v4.00', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'T12 lamp rated hours', '20000.00', '1.000', '4760.0', '15.00', '4.20', '0.40', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('254', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3141.5', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('255', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2630.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('256', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2430.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('257', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('258', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2480.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('259', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2290.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('260', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('261', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4900.0', '15.00', '14.29', '4.76', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('262', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '5230.0', '15.00', '13.38', '4.46', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('263', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1950.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('264', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3510.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('265', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3220.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('266', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1570.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('267', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('268', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2640.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('269', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2590.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('270', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4840.0', '15.00', '14.46', '4.82', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('271', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4830.0', '15.00', '14.49', '4.83', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('272', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('273', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4260.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('274', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3380.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('275', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('276', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('277', 'ILtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'HID_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4760.0', '15.00', '14.71', '4.90', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('278', 'ILtg-OccSens', 'Occupancy Sensors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'OccSens', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('279', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3141.5', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('280', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2630.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('281', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2430.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('282', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('283', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2480.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('284', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2290.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('285', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('286', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4900.0', '15.00', '14.29', '4.76', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('287', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '5230.0', '15.00', '13.38', '4.46', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('288', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1950.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('289', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3510.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('290', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3220.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('291', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '1570.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('292', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4140.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('293', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2640.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('294', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '2590.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('295', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4840.0', '15.00', '14.46', '4.82', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('296', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4830.0', '15.00', '14.49', '4.83', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('297', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3370.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('298', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4260.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('299', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3380.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('300', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('301', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '3420.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('302', 'ILtg-T5', 'HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4760.0', '15.00', '14.71', '4.90', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('303', 'ILtg-TmClck', 'Timeclocks', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'Timer', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('304', 'Motors-fan', 'HVAC Fan Motors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC-Vent', 'HV_AirDist', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('305', 'Motors-HiEff', 'Premium-Efficiency Motors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', '', '', 'Motor', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('306', 'Motors-pump', 'Water Loop Pumps', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', '', '', 'LiqCirc', 'PumpMtr', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('307', 'OLtg-All-TmClk', 'Timeclock with or without photocell', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'Timer', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('308', 'OLtg-All-TmClkPhoto', 'Timeclock with or without photocell', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'Timer OR LtSensor', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('309', 'OLtg-CFL', 'Timeclock with or without photocell', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'Timer OR LtSensor', 'Any', 'Any', 'rated years', null, null, null, '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('310', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Asm', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('333', 'OLtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'DMO', 'Any', 'lamp rated hours', '10000.00', '1.000', '1131.0', '15.00', '8.84', '2.95', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('311', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'ECC', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('312', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'EPr', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('313', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'ERC', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('314', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'ESe', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('315', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'EUn', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('316', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Gro', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('317', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Hsp', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('318', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Htl', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('319', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'MBT', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('334', 'OLtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'MFM', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('320', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'MLI', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('321', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Mtl', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('322', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Nrs', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('323', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'OfL', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('324', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'OfS', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('335', 'OLtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Res', 'Any', 'rated years', null, null, null, null, '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('325', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RFF', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('326', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RSD', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('327', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Rt3', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('328', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RtL', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('329', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'RtS', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('330', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'SCn', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('336', 'OLtg-CFL', 'CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'SFM', 'Any', 'lamp rated hours', '10000.00', '1.000', '1131.0', '15.00', '8.84', '2.95', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('331', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'SUn', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('332', 'OLtg-CFL', 'Outdoor CFL Lamps - 10,000 Hour', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'WRf', 'Any', 'lamp rated hours', '10000.00', '1.000', '4100.0', '15.00', '2.44', '0.81', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('337', 'OLtg-CFLfix', 'CFL Fixtures', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'CFL_fixt', 'Res', 'Any', 'rated years', null, null, null, '15.00', '16.00', '5.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('338', 'OLtg-HID', 'HID Lighting', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'DMO', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('339', 'OLtg-HID', 'HID Lighting', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'MFM', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('340', 'OLtg-HID', 'HID Lighting', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'SFM', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('341', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('342', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('343', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('344', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('345', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('346', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('347', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('348', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('349', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('350', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('351', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('352', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('353', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('354', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('355', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('356', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('357', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('358', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('359', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('360', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('361', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('362', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('363', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('364', 'OLtg-HPS', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('516', 'Oltg-LED', 'LED Lighting', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'CC', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LED_fixt', 'Any', 'Any', 'lamp rated hours', '50000.00', '1.000', null, '12.00', '12.00', null, '', 'Proposed');
INSERT INTO "costeff"."EUL" VALUES ('365', 'OLtg-LFluor', 'HID Lighting - High Pressure Sodium', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('366', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('389', 'OLtg-LFluor', 'Linear Fluorescents - Home', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'DMO', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('367', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('368', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('369', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('370', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('371', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('372', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('373', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('374', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('375', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('376', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('377', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('378', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('379', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('380', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('381', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('382', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('383', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('384', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('385', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('386', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('390', 'OLtg-LFluor', 'Linear Fluorescents - Home', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SFM', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('387', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('388', 'OLtg-LFluor', 'Outdoor Linear Fluorescent with Electronic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('392', 'OLtg-LFluor-CommArea', 'Linear Fluorescents - MF Common Area', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('391', 'OLtg-LFluor-CommArea', 'Linear Fluorescents - MF Common Area', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MFM', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('393', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('394', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('395', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('396', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('397', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('398', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('399', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('400', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('401', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('402', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('403', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('404', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('405', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('406', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('407', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('408', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('409', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('410', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('411', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('412', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('413', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('414', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('415', 'OLtg-Lfluor-Mag', 'Outdoor Linear Fluorescent with Magnetic Ballast', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('416', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Any', 'Any', 'magnetic ballast rated hours', '45000.00', '1.000', '4100.0', '15.00', '10.98', '3.66', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('417', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('418', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('419', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('420', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('421', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('422', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('423', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('424', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('425', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('426', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('427', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('428', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('429', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('430', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('431', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('432', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('433', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('434', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('435', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('436', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('437', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('438', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('439', 'OLtg-MH', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('440', 'OLtg-T5', 'HID Lighting - Metal Halide', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'HID_fixt', 'Any', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('441', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Asm', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('442', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ECC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('443', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EPr', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('444', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ERC', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('445', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'ESe', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('446', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'EUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('447', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Gro', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('448', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Hsp', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('449', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Htl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('450', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MBT', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('451', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'MLI', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('452', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Mtl', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('453', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Nrs', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('454', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('455', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'OfS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('456', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RFF', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('457', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RSD', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('458', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Rt3', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('459', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtL', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('460', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'RtS', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('461', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SCn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('462', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'SUn', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('463', 'OLtg-T5', 'Outdoor HID Lighting (T-5)', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-OLtGen', 'Ltg_Wired', 'LinFluor_fixt', 'WRf', 'Any', 'electronic ballast rated hours', '70000.00', '1.000', '4100.0', '15.00', '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('464', 'OLtg-TmClck', 'Timeclock with or without photocell', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', '', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('465', 'OutD-PoolPump', 'High Efficiency Pool Pump', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'Rec', 'Rec-Pool', 'LiqCirc', 'PmpMtr', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('466', 'Plug-80plus', '80 PLUS Power Supply', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'APlg', 'Aplg-OffEq', 'Electronics', '', 'Com', 'Any', 'rated years', null, null, null, null, '4.00', '1.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('467', 'Plug-HiEffCopier', 'High Efficiency Copiers', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'APlg', 'Aplg-OffEq', 'Electronics', 'AllEquip', 'Com', 'Any', 'rated years', null, null, null, null, '6.00', '2.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('468', 'Plug-OccSens', 'Occupancy sensors', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'APlg', 'Aplg-OffEq', 'Electronics', 'MoveSensor', 'Com', 'Any', 'rated years', null, null, null, null, '8.00', '2.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('469', 'Plug-VendCtrler', 'Vending Machine Controller', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'APlg', 'Aplg-PrVnd', 'Electronics', 'MoveSensor', 'Com', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('470', 'PrcHt-Blr', 'High Efficiency Boiler ', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcHeat', '', 'WaterHtg_eq', 'Boiler_Et', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('471', 'PrcHt-StmTrp', 'Steam Traps', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcHeat', 'ProcHt-StmDist', 'SteamCirc', 'SteamTrap', 'Com', 'Any', 'rated years', null, null, null, null, '6.00', '2.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('472', 'RefgWrhs-Comp', 'Refrigerator Upgrades (Variable Speed Compressors)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('473', 'RefgWrhs-Cond', 'Refrigerator Upgrades (Condenser)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('474', 'RefgWrhs-FltHdPres', 'Refrigerator Upgrades (Suction Pressure)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('475', 'RefgWrhs-FltSucPres', 'Refrigerator Upgrades (Head Pressure)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('476', 'RefgWrhs-Retro', 'Retrocommissioning', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Service', 'Retro', '', '', 'Com', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('477', 'RefgWrhs-ScrollComp', 'Scroll Compressors for Bulk Tanks', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '12.00', '4.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('478', 'RefgWrhs-SLIns', 'Insulation for Bare Suction Lines', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('479', 'RefgWrhs-SubClr', 'Refrigerator Upgrades (Subcooling)
', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'ProcRefrig', 'ProcRef-ProdStor', 'Chiller', 'RefWareCool', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('481', 'WtrHt-CntLrgInst-Elec', 'Instantaneous Water Heater - Electric', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_EF', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('480', 'WtrHt-CntLrgInst-Gas', 'Instantaneous Water Heater - Gas', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_Et', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('482', 'WtrHt-CntLrgStrg-Elec', 'High Efficiency Electric Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Res', 'Any', 'rated years', null, null, null, null, '13.00', '4.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('483', 'WtrHt-CntLrgStrg-Gas', 'High Efficiency Electric Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_Et', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('484', 'WtrHt-CntMedInst-Elec', 'Central Medium Instantaneous Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_EF', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('485', 'WtrHt-Cntrl-Gas', 'High Efficiency Central Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', '', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('486', 'WtrHt-CntSmlInst-Elec', 'Central Small Instantaneous Water Heater - Electric', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_EF', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('487', 'WtrHt-CntSmlInst-Gas', 'Central Small Instantaneous Water Heater - Gas', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_EF', 'Res', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('488', 'WtrHt-CntSmlStrg-Elec', 'Central Small High Efficiency Electric Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Res', 'Any', 'rated years', null, null, null, null, '13.00', '4.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('489', 'WtrHt-CntSmlStrg-Gas', 'Central Small High Efficiency Gas Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('490', 'WtrHt-GPoolHtr', 'Commercial Pool Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'Recreate', 'Rec-Pool', 'WaterHtg_eq', '', 'Com', 'Any', 'rated years', null, null, null, null, '5.00', '1.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('491', 'WtrHt-HtPmp', 'Heat Pump Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'HP_EF', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('492', 'WtrHt-LrgInst-Elec', 'Instantaneous Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_EF', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('493', 'WtrHt-LrgInst-Gas', 'Instantaneous Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_Et', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('494', 'WtrHt-LrgStrg-Elec', 'High Efficiency Commercial Storage Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('495', 'WtrHt-LrgStrg-Gas', 'High Efficiency Commercial Storage Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_Et', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('496', 'WtrHt-MedInst', 'Instantaneous Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Instant_EF', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('497', 'WtrHt-PipeIns-Elec', 'Pipe Insulation - Electric Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Dist', 'LiqCirc', 'PipeIns', 'Com', 'Any', 'rated years', null, null, null, null, '13.00', '4.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('498', 'WtrHt-PipeIns-Gas', 'Pipe Insulation - Gas Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Dist', 'LiqCirc', 'PipeIns', 'Com', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('500', 'WtrHt-SmlInst', 'Instantaneous Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-HWPoU', 'WaterHtg_eq', 'Instant_EF', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('499', 'WtrHt-SmlInst+C521', 'Instantaneous Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-HWPoU', 'WaterHtg_eq', 'Instant_EF', 'Com', 'Any', 'rated years', null, null, null, null, '20.00', '6.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('501', 'WtrHt-SmlStrg-Elec', 'High Efficiency Commercial Storage Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('503', 'WtrHt-SmlStrg-Elec', 'High Efficiency Commercial Storage Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Res', 'Any', 'rated years', null, null, null, null, '13.00', '4.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('502', 'WtrHt-SmlStrg-Gas', 'High Efficiency Commercial Storage Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('504', 'WtrHt-SmlStrg-Gas', 'High Efficiency Commercial Storage Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'Stor_EF', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('505', 'WtrHt-SWH', 'Solar Water Heating', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WaterHtg_eq', '', 'Res', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('506', 'WtrHt-TankIns-Elec', 'Water Heater Tank Wrap', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'TankIns', 'Com', 'Any', 'rated years', null, null, null, null, '7.00', '2.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('507', 'WtrHt-TankIns-Gas', 'Water Heater Tank Wrap', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', 'TankIns', 'Com', 'Any', 'rated years', null, null, null, null, '7.00', '2.33', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('508', 'WtrHt-Timeclock', 'Circulation Pump Timeclock Retrofit', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Dist', 'LiqCirc', 'Timer', 'Com', 'Any', 'rated years', null, null, null, null, '15.00', '5.00', '', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('509', 'WtrHt-WH-Aertr', 'Faucet Aerators', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'All', 'SHW', 'SHW-Dist', 'WaterFixt', 'FaucetAer', 'Any', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', 'proposed in PGE3PHVC100', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('510', 'WtrHt-WH-R4PipeIns-Elec', 'Pipe Insulation - Electric Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'LiqCirc', 'PipeIns', 'Res', 'Any', 'rated years', null, null, null, null, '13.00', '4.33', 'proposed in PGE3PHVC100', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('511', 'WtrHt-WH-R4PipeIns-Gas', 'Pipe Insulation - Gas Water Heater', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'LiqCirc', 'PipeIns', 'Res', 'Any', 'rated years', null, null, null, null, '11.00', '3.67', 'proposed in PGE3PHVC100', 'Standard');
INSERT INTO "costeff"."EUL" VALUES ('512', 'WtrHt-WH-Shrhd', 'Low-Flow Showerhead', 'DEER2011', 'D08 v2.05', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'WaterFixt', 'ShowerHd', 'Res', 'Any', 'rated years', null, null, null, null, '10.00', '3.33', 'proposed in PGECOLTG151', 'Standard');

-- ----------------------------
-- Table structure for "costeff"."GSIA"
-- ----------------------------
DROP TABLE "costeff"."GSIA";
CREATE TABLE "costeff"."GSIA" (
"Index" int2 NOT NULL,
"GSIA_ID" varchar(255),
"Description" varchar(255),
"Version" varchar(255),
"VersionSrc" varchar(255),
"LastMod" timestamp(6),
"IOU" varchar(255),
"BldgType" varchar(255),
"BldgVint" varchar(255),
"IOUSubProg" varchar(255),
"ImplementerID" varchar(255),
"Sector" varchar(255),
"UseCategory" varchar(255),
"UseSubCat" varchar(255),
"TechGroup" varchar(255),
"TechType" varchar(255),
"TechID" varchar(255),
"ProgDelivID" varchar(255),
"GSIAType" varchar(255),
"GSIAValue" numeric(8,3),
"DelInstSchID" varchar(255),
"Status" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of GSIA
-- ----------------------------
INSERT INTO "costeff"."GSIA" VALUES ('1', 'Res-CFL-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DownPreReb', 'AnnInstRate', '0.890', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('2', 'Res-CFL-DirInstall', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DirInstall', 'AnnInstRate', '0.890', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('3', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'InvVerRate', '0.960', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('4', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnSalesRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('5', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'LeakRate', '0.990', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('6', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('7', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'DelInstRate', '0.670', 'Upstrm-CFL-1yr', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('8', 'Com-CFL-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DownPreReb', 'AnnInstRate', '0.790', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('9', 'Com-CFL-DirInstall', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DirInstall', 'AnnInstRate', '0.878', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('10', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'InvVerRate', '0.960', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('11', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnSalesRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('12', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'LeakRate', '0.990', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('13', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('14', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'DelInstRate', '0.730', 'Upstrm-CFL-1yr', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('15', 'Res-CFL-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DownPreReb', 'AnnInstRate', '0.720', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('16', 'Res-CFL-DirInstall', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DirInstall', 'AnnInstRate', '0.720', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('17', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'InvVerRate', '0.990', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('18', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnSalesRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('19', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'LeakRate', '0.960', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('20', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('21', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'DelInstRate', '0.770', 'Upstrm-CFL-1yr', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('22', 'Com-CFL-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DownPreReb', 'AnnInstRate', '0.630', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('23', 'Com-CFL-DirInstall', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DirInstall', 'AnnInstRate', '0.700', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('24', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'InvVerRate', '0.990', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('25', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnSalesRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('26', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'LeakRate', '0.930', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('27', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('28', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'DelInstRate', '0.810', 'Upstrm-CFL-1yr', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('29', 'Res-CFL-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DownPreReb', 'AnnInstRate', '0.710', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('30', 'Res-CFL-DirInstall', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DirInstall', 'AnnInstRate', '0.710', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('31', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'InvVerRate', '0.960', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('32', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnSalesRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('33', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'LeakRate', '0.930', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('34', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('35', 'Res-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Res', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'DelInstRate', '0.670', 'Upstrm-CFL-1yr', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('36', 'Com-CFL-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DownPreReb', 'AnnInstRate', '0.780', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('37', 'Com-CFL-DirInstall', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'DirInstall', 'AnnInstRate', '0.867', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('38', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'InvVerRate', '0.960', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('39', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnSalesRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('40', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'LeakRate', '0.930', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('41', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('42', 'Com-CFL-UpPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'UpPreReb', 'DelInstRate', '0.760', 'Upstrm-CFL-1yr', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('43', 'Com-LinFluor-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.920', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('44', 'Com-HID-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'HID_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.920', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('45', 'Com-LinFluor_DownPreReb-rplHID', 'T5 replaces HID fixture', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.920', '', '', 'for measures that replace HID with T5 Linear Fluorescent');
INSERT INTO "costeff"."GSIA" VALUES ('46', 'Com-Exit-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'Exit_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.900', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('47', 'Com-LinFluor-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.950', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('48', 'Com-HID-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'HID_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.930', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('49', 'Com-LinFluor_DownPreReb-rplHID', 'T5 replaces HID fixture', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.930', '', '', 'for measures that replace HID with T5 Linear Fluorescent');
INSERT INTO "costeff"."GSIA" VALUES ('50', 'Com-Exit-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'Exit_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.900', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('51', 'Com-LinFluor-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.900', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('52', 'Com-HID-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'HID_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('53', 'Com-LinFluor_DownPreReb-rplHID', 'T5 replaces HID fixture', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '1.000', '', '', 'for measures that replace HID with T5 Linear Fluorescent');
INSERT INTO "costeff"."GSIA" VALUES ('54', 'Com-Exit-DownPreReb', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'Exit_fixt', 'Any', 'DownPreReb', 'AnnInstRate', '0.900', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('55', 'Com-LinFluor-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.951', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('56', 'Com-HID-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'HID_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.939', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('57', 'Com-LinFluor_DirInst-rplHID', 'T5 replaces HID fixture', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.939', '', '', 'for measures that replace HID with T5 Linear Fluorescent');
INSERT INTO "costeff"."GSIA" VALUES ('58', 'Com-Exit-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'Exit_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.919', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('59', 'Com-LinFluor-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.982', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('60', 'Com-HID-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'HID_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.950', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('61', 'Com-LinFluor_DirInst-rplHID', 'T5 replaces HID fixture', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.950', '', '', 'for measures that replace HID with T5 Linear Fluorescent');
INSERT INTO "costeff"."GSIA" VALUES ('62', 'Com-Exit-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SCE', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'Exit_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.919', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('63', 'Com-LinFluor-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.930', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('64', 'Com-HID-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'HID_fixt', 'Any', 'DirInstall', 'AnnInstRate', '1.021', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('65', 'Com-LinFluor_DirInst-rplHID', 'T5 replaces HID fixture', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'DirInstall', 'AnnInstRate', '1.021', '', '', 'for measures that replace HID with T5 Linear Fluorescent');
INSERT INTO "costeff"."GSIA" VALUES ('66', 'Com-Exit-DirInst', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'SDG', 'Any', 'Any', 'Any', 'Any', 'Com', 'Lighting', 'Any', 'Ltg_Wired', 'Exit_fixt', 'Any', 'DirInstall', 'AnnInstRate', '0.919', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('67', 'Default-GSIA', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'AnnInstRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('68', 'Custom-Reviewed', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'GrRealRate', '1.000', '', '', '');
INSERT INTO "costeff"."GSIA" VALUES ('69', 'Custom-Not-Reviewed', '', 'DEER2011', 'MV0608', '0001-01-01 00:00:00', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'Any', 'GrRealRate', '0.900', '', '', '');

-- ----------------------------
-- Table structure for "costeff"."LaborRates"
-- ----------------------------
DROP TABLE "costeff"."LaborRates";
CREATE TABLE "costeff"."LaborRates" (
"Index" int2 NOT NULL,
"Version" varchar(255) NOT NULL,
"VersionSrc" varchar(255),
"Code" varchar(255) NOT NULL,
"Sector" varchar(255) NOT NULL,
"BaseLaborRate" numeric(8,2) NOT NULL,
"Application" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of LaborRates
-- ----------------------------
INSERT INTO "costeff"."LaborRates" VALUES ('1', 'DEER2008', 'D08 v2.05', 'DHW-Pipe-Tank', 'CC', '47.15', 'Domestic Hot Water - Pipe Wrap', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('2', 'DEER2008', 'D08 v2.05', 'HVAC-Duct', 'Res', '43.60', 'HVAC - Duct Insulation', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('3', 'DEER2008', 'D08 v2.05', 'NR-DHW-SWH', 'Com', '58.80', 'Domestic Hot Water - Storage Water Heaters', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('4', 'DEER2008', 'D08 v2.05', 'NR-HVAC-AC', 'Com', '67.88', 'HVAC - Package', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('5', 'DEER2008', 'D08 v2.05', 'NR-HVAC-B', 'Com', '67.88', 'HVAC - Boiler', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('6', 'DEER2008', 'D08 v2.05', 'NR-HVAC-CH', 'Com', '67.88', 'HVAC - Chiller', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('7', 'DEER2008', 'D08 v2.05', 'NR-HVAC-PT', 'Com', '48.35', 'HVAC - Programmable Thermostats', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('8', 'DEER2008', 'D08 v2.05', 'NR-IL-ALL', 'Com', '67.88', 'Indoor Lighting - Other Lighting', 'All Program Delivery Strategies');
INSERT INTO "costeff"."LaborRates" VALUES ('9', 'DEER2008', 'D08 v2.05', 'NR-IL-DI', 'Com', '67.88', 'Indoor Lighting - Other Lighting', 'Direct Installation- measures only');
INSERT INTO "costeff"."LaborRates" VALUES ('10', 'DEER2008', 'D08 v2.05', 'NR-IL-DP', 'Com', '67.88', 'Indoor Lighting - Other Lighting', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('11', 'DEER2008', 'D08 v2.05', 'NR-IL-OL', 'Com', '67.88', 'Indoor Lighting - Other Lighting', '');
INSERT INTO "costeff"."LaborRates" VALUES ('12', 'DEER2008', 'D08 v2.05', 'NR-MISC', 'Com', '67.88', 'Miscellaneous - NA', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('13', 'DEER2008', 'D08 v2.05', 'NR-MO', 'Com', '65.00', 'Motors - NA', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('14', 'DEER2008', 'D08 v2.05', 'NR-OCP', 'Com', '67.88', 'Other Central Plant - NA', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('15', 'DEER2008', 'D08 v2.05', 'NR-RE-CTL', 'Com', '67.88', 'Refrigeration - Controls', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('16', 'DEER2008', 'D08 v2.05', 'NR-Shell-Win', 'Com', '56.00', 'Buidling Shell - Windows', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('17', 'DEER2008', 'D08 v2.05', 'R-App', 'Res', '48.60', 'Appliances - Refrigerators', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('18', 'DEER2008', 'D08 v2.05', 'R-DHW-LF', 'Res', '48.60', 'Domestic Hot Water - Water Conservation', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('19', 'DEER2008', 'D08 v2.05', 'R-DHW-SWH', 'Res', '58.80', 'Domestic Hot Water - Storage Water Heaters', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('20', 'DEER2008', 'D08 v2.05', 'R-HVAC-PA', 'Res', '67.88', 'HVAC - Package', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('21', 'DEER2008', 'D08 v2.05', 'R-HVAC-PT', 'Res', '48.35', 'HVAC - Programmable Thermostats', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('22', 'DEER2008', 'D08 v2.05', 'R-IL-ALL', 'Res', '67.88', 'Indoor Lighting - Other Lighting', 'All Program Delivery Strategies');
INSERT INTO "costeff"."LaborRates" VALUES ('23', 'DEER2008', 'D08 v2.05', 'R-IL-DI', 'Res', '67.88', 'Indoor Lighting - Other Lighting', 'Direct Installation- measures only');
INSERT INTO "costeff"."LaborRates" VALUES ('24', 'DEER2008', 'D08 v2.05', 'R-IL-DP', 'Res', '67.88', 'Indoor Lighting - Other Lighting', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('25', 'DEER2008', 'D08 v2.05', 'R-OL-DP', 'Res', '67.88', 'Outdoor Lighting - Other Lighting', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('26', 'DEER2008', 'D08 v2.05', 'R-Shell-Scn', 'Res', '56.00', 'Building Shell - Window Film and Screens', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('27', 'DEER2008', 'D08 v2.05', 'R-Shell-Win', 'Res', '43.60', 'Buidling Shell - Windows', 'Downstream Prescriptive Rebates/Incentives');
INSERT INTO "costeff"."LaborRates" VALUES ('28', 'DEER2008', 'D08 v2.05', 'Shell-Insulation', 'Res', '43.60', 'Buidling Shell - Ceiling', 'Downstream Prescriptive Rebates/Incentives');

-- ----------------------------
-- Table structure for "costeff"."MeasureCost"
-- ----------------------------
DROP TABLE "costeff"."MeasureCost";
CREATE TABLE "costeff"."MeasureCost" (
"Index" int2,
"MeasCostID" varchar(255),
"Description" varchar(255),
"NormUnit" varchar(255),
"Version" varchar(255),
"VersionSrc" varchar(255),
"LastMod" timestamp(6),
"IOU" varchar(255),
"BldgType" varchar(255),
"BldgVint" varchar(255),
"BldgLoc" varchar(255),
"CostQualifier" varchar(255),
"CostType" varchar(255),
"GenCost" numeric(8,2),
"LaborCost" numeric(8,2),
"MatlCost" numeric(8,2),
"InstallHrs" numeric(8,2),
"LaborRate" numeric(8,2),
"LocCostAdj" varchar(255),
"Status" varchar(255),
"Comment" varchar(255)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of MeasureCost
-- ----------------------------
INSERT INTO "costeff"."MeasureCost" VALUES ('1', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ06', 'None', 'Incremental', '0.00', '2.92', '6.53', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('2', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ08', 'None', 'Incremental', '0.00', '2.86', '7.02', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('3', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ09', 'None', 'Incremental', '0.00', '3.10', '7.22', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('4', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ10', 'None', 'Incremental', '0.00', '2.80', '6.78', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('5', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ13', 'None', 'Incremental', '0.00', '2.57', '6.71', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('6', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ14', 'None', 'Incremental', '0.00', '2.67', '6.59', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('7', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ15', 'None', 'Incremental', '0.00', '2.80', '7.02', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('8', 'WPSCNRRN0007_Cost', 'installation of infiltration barriers (i. e. strip curtains) on walk-in coolers and freezers where none previously existed', 'Len-Ft', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'SCE', 'Com', 'Ex', 'CZ16', 'None', 'Incremental', '0.00', '2.86', '7.40', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('9', 'PGECOLTG151-50WLED', 'installation of 50W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '106.00', '580.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('10', 'PGECOLTG151-70WLED', 'installation of 70W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '156.00', '666.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('11', 'PGECOLTG151-110WLED', 'installation of 110W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '156.00', '900.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('12', 'PGECOLTG151-150WLED', 'installation of 150W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '1280.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('13', 'PGECOLTG151-192WLED', 'installation of 192W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '1480.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('14', 'PGECOLTG151-225WLED', 'installation of 225W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '1729.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('15', 'PGECOLTG151-265WLED', 'installation of 265W LED Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '1828.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('16', 'PGECOLTG151-70WHID', 'installation of 70W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '106.00', '278.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('17', 'PGECOLTG151-100WHID', 'installation of 100W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '156.00', '235.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('18', 'PGECOLTG151-150WHID', 'installation of 150W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '156.00', '235.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('19', 'PGECOLTG151-200WHID', 'installation of 200W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '510.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('20', 'PGECOLTG151-250WHID', 'installation of 250W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '510.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('21', 'PGECOLTG151-310WHID', 'installation of 310W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '510.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('22', 'PGECOLTG151-400WHID', 'installation of 400W HID Fixture', 'Fixture', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '0.00', '192.00', '510.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('23', 'PGECOFST106-Reflt15cf_MT', 'High efficiency commercial glass door refrigerator lt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '1478.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('24', 'PGECOFST106-Ref15-30cf_MT', 'High efficiency commercial glass door refrigerator 15-30cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '2105.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('25', 'PGECOFST106-Ref30-50cf_MT', 'High efficiency commercial glass door refrigerator 30-50cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '3397.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('26', 'PGECOFST106-Refgt50cf_MT', 'High efficiency commercial glass door refrigerator gt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '10435.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('27', 'PGECOFST106-Frzlt15cf_MT', 'High efficiency commercial glass door Freezer lt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '725.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('28', 'PGECOFST106-Frz15-30cf_MT', 'High efficiency commercial glass door Freezer 15-30cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '5250.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('29', 'PGECOFST106-Frz30-50cf_MT', 'High efficiency commercial glass door Freezer 30-50cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '6483.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('30', 'PGECOFST106-Frzgt50cf_MT', 'High efficiency commercial glass door Freezer gt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '9698.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('31', 'PGECOFST106-Reflt15cf_CS', 'Standard efficiency commercial glass door refrigerator lt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '1452.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('32', 'PGECOFST106-Ref15-30cf_CS', 'Standard efficiency commercial glass door refrigerator 15-30cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '2031.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('33', 'PGECOFST106-Ref30-50cf_CS', 'Standard efficiency commercial glass door refrigerator 30-50cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '3254.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('34', 'PGECOFST106-Refgt50cf_CS', 'Standard efficiency commercial glass door refrigerator gt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '9840.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('35', 'PGECOFST106-Frzlt15cf_CS', 'Standard efficiency commercial glass door Freezer lt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '698.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('36', 'PGECOFST106-Frz15-30cf_CS', 'Standard efficiency commercial glass door Freezer 15-30cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '5008.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('37', 'PGECOFST106-Frz30-50cf_CS', 'Standard efficiency commercial glass door Freezer 30-50cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '6008.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('38', 'PGECOFST106-Frzgt50cf_CS', 'Standard efficiency commercial glass door Freezer gt15cf', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Any', 'Any', 'PGE', 'None', 'Full', '8546.00', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('39', 'PGE3PHVC100_Cost', 'installation of PTAC thermostat with automatic power controller and infra-red occupancy sensor', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Gst', 'Any', 'PGE', 'None', 'Full', '256.69', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('40', 'PGE3PHVC100_Cost', 'installation of PTAC thermostat with automatic power controller and infra-red occupancy sensor', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Htl', 'Any', 'PGE', 'None', 'Full', '256.69', '0.00', '0.00', null, null, '', '', '');
INSERT INTO "costeff"."MeasureCost" VALUES ('41', 'PGE3PHVC100_Cost', 'installation of PTAC thermostat with automatic power controller and infra-red occupancy sensor', 'Each', '2010 Ex-Ante', 'IOU Workpaper', '0001-01-01 00:00:00', 'PGE', 'Mtl', 'Any', 'PGE', 'None', 'Full', '256.69', '0.00', '0.00', null, null, '', '', '');

-- ----------------------------
-- Table structure for "costeff"."NTGR"
-- ----------------------------
DROP TABLE "costeff"."NTGR";
CREATE TABLE "costeff"."NTGR" (
"Index" int2 NOT NULL,
"NTG_ID" varchar(255) NOT NULL,
"Description" varchar(255),
"Version" varchar(255) NOT NULL,
"VersionSrc" varchar(255),
"LastMod" timestamp(6),
"Sector" varchar(255),
"UseCategory" varchar(255),
"UseSubCat" varchar(255) NOT NULL,
"TechGroup" varchar(255),
"TechType" varchar(255),
"BldgType" varchar(255) NOT NULL,
"BldgVint" varchar(255) NOT NULL,
"NTGqual" varchar(255) NOT NULL,
"ProgDelivID" varchar(255) NOT NULL,
"IOUProgram" varchar(255) NOT NULL,
"IOUSubProg" varchar(255) NOT NULL,
"NTGR_kWh" numeric(8,2),
"Comment" varchar(255),
"Documentation" varchar(255),
"Status" varchar(255),
"IOU" varchar(255),
"NTGR_kW" numeric(8,2),
"NTGR_therm" numeric(8,2),
"NTGR_cost" numeric(8,2)
)
WITH (OIDS=FALSE)

;

-- ----------------------------
-- Records of NTGR
-- ----------------------------
INSERT INTO "costeff"."NTGR" VALUES ('88', 'NonRes-Default', 'New Measures not Otherwise Addressed ', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'ModMarketNR', 'ModMarket', 'Any', 'Any', null, '', '', '', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('176', 'NonRes-Default', 'New Measures not Otherwise Addressed ', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'ModMarketNR', 'ModMarket', 'Any', 'Any', '0.70', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('87', 'NonRes-Default-HTR', 'New Measures not Otherwise Addressed OR Existing Direct Installed measures for Hard to Reach markets', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'VLowMarket', 'InnovDelivDI', 'Any', 'Any', '0.80', '', 'Overview of DEER Documentation and Rationale for Default Values- Chapter 1', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('175', 'NonRes-Default-HTR', 'New Measures not Otherwise Addressed OR Existing Direct Installed measures for Hard to Reach markets', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'VLowMarket', 'InnovDelivDI', 'Any', 'Any', '0.85', '', 'Overview of DEER Documentation and Rationale for Default Values- Chapter 1', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('80', 'NonRes-sAg-mAll', 'All other', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('168', 'NonRes-sAg-mAll', 'All other', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('78', 'NonRes-sAg-mMilkHR', 'Compressor Heat Recovery Units', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcHeat', 'ProcHeat-PreLS', 'HtExchanger', 'Proc_HeatRecov', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('166', 'NonRes-sAg-mMilkHR', 'Compressor Heat Recovery Units', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'SHW', '', '', '', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('77', 'NonRes-sAg-mMilkPC', 'Plate Coolers', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcRefrig', 'ProcRef-ProdChl', 'HtExchanger', 'PlateClr', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.26', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('165', 'NonRes-sAg-mMilkPC', 'Plate Coolers', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcRefrig', 'ProcRef-ProdChl', 'HtExchanger', 'PlateClr', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.26', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('76', 'NonRes-sAg-mMilkSC', 'Scroll Compressors', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcRefrig', 'ProcRef-ProdChl', 'Chiller', 'Scroll', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('164', 'NonRes-sAg-mMilkSC', 'Scroll Compressors', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcRefrig', 'ProcRef-ProdChl', 'Chiller', 'Scroll', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('79', 'NonRes-sAg-mMilkVP', 'Vacuum Pump VSDs', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcDist', 'ProcDist-Pmp', 'Motor_Spd', 'ASD', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.75', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('167', 'NonRes-sAg-mMilkVP', 'Vacuum Pump VSDs', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcDist', 'ProcDist-Pmp', 'Motor_Spd', 'ASD', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.75', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('75', 'NonRes-sAg-mMilkVSD', 'Milk Pump VSDs', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcDist', 'ProcDist-Pmp', 'Motor_Spd', 'ASD', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('163', 'NonRes-sAg-mMilkVSD', 'Milk Pump VSDs', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Ag', 'ProcDist', 'ProcDist-Pmp', 'Motor_Spd', 'ASD', 'ADF', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Agricultural Market-Chapter 16', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('82', 'NonRes-sAll-mAudit', 'All Measures **', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Any', 'Any', 'lt100kW', 'OnSiteAudit', 'Any', 'Any', '0.48', '', 'Non Residential Audits-Chapter 11', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('170', 'NonRes-sAll-mAudit', 'All Measures **', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Any', 'Any', 'lt100kW', 'OnSiteAudit', 'Any', 'Any', '0.48', '', 'Non Residential Audits-Chapter 11', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('81', 'NonRes-sAll-mAudit-lrg', 'All Measures **', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Any', 'Any', 'ge100kW', 'OnSiteAudit', 'Any', 'Any', '0.46', '', 'Non Residential Audits-Chapter 11', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('169', 'NonRes-sAll-mAudit-lrg', 'All Measures **', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Any', 'Any', 'ge100kW', 'OnSiteAudit', 'Any', 'Any', '0.46', '', 'Non Residential Audits-Chapter 11', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('83', 'NonRes-sAll-mAudit-sml', 'All Measures **', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Any', 'Any', 'lt20kW', 'RemAudit', 'Any', 'Any', '0.29', '', 'Non Residential Audits-Chapter 11', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('171', 'NonRes-sAll-mAudit-sml', 'All Measures **', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgSys', 'Diag', 'NA', 'NA', 'Any', 'Any', 'lt20kW', 'RemAudit', 'Any', 'Any', '0.29', '', 'Non Residential Audits-Chapter 11', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('47', 'NonRes-sAll-mCFL-dir', 'CFLs', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'multiple technologies', 'multiple technologies', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('135', 'NonRes-sAll-mCFL-dir', 'CFLs', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', '', '', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('46', 'NonRes-sAll-mCFL-dn', 'CFLs', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'multiple technologies', 'multiple technologies', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.81', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('134', 'NonRes-sAll-mCFL-dn', 'CFLs', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', '', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.81', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('45', 'NonRes-sAll-mCFLgt30', 'CFL-screw in, >30 Watt excluding reflector/dimmable', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting-Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('133', 'NonRes-sAll-mCFLgt30', 'CFL-screw in, >30 Watt excluding reflector/dimmable', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting-Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('43', 'NonRes-sAll-mCFLle30', 'CFL-screw in, <=30 watt', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.60', '', 'Residential Lighting-Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('131', 'NonRes-sAll-mCFLle30', 'CFL-screw in, <=30 watt', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.60', '', 'Residential Lighting-Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('44', 'NonRes-sAll-mCFLspec', 'CFL-screw in - Specialty bulbs, Reflector/Dimmable', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting-Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('132', 'NonRes-sAll-mCFLspec', 'CFL-screw in - Specialty bulbs, Reflector/Dimmable', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', null, '', 'Residential Lighting-Chapter 2', '', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('71', 'NonRes-sAll-mCustElec', 'Custom Electric Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'None', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('159', 'NonRes-sAll-mCustElec', 'Custom Electric Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'None', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('73', 'NonRes-sAll-mCustElec-lrg', 'Custom Electric Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.54', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('161', 'NonRes-sAll-mCustElec-lrg', 'Custom Electric Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.64', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('72', 'NonRes-sAll-mCustGas', 'Custom Gas Measures.', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('160', 'NonRes-sAll-mCustGas', 'Custom Gas Measures.', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('74', 'NonRes-sAll-mCustGas-lrg', 'Custom Gas Measures.', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.54', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('162', 'NonRes-sAll-mCustGas-lrg', 'Custom Gas Measures.', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.64', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('51', 'NonRes-sAll-mDLCtrl', 'Daylighting Controls', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'LtSensor', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.64', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('139', 'NonRes-sAll-mDLCtrl', 'Daylighting Controls', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'LtSensor', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.64', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('60', 'NonRes-sAll-mFilm', 'Window Film', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Fen', 'Fenest', 'WinFilm', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('148', 'NonRes-sAll-mFilm', 'Window Film', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgEnv', 'Env-Fen', 'Fenest', 'WinFilm', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('86', 'NonRes-sAll-mGovPart', 'All Measures ', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Ex', 'LocGovPart', 'Various', 'Any', 'Any', null, 'NTG value is  weighted average of applicable NTG for measures and end uses implemented through the third party or local government program', '', '', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('174', 'NonRes-sAll-mGovPart', 'All Measures ', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Ex', 'LocGovPart', 'Various', 'Any', 'Any', null, '', '', '', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('61', 'NonRes-sAll-mHVAC', 'All HVAC Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', '', '', '', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.54', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('149', 'NonRes-sAll-mHVAC', 'All HVAC Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', '', '', '', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.64', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('65', 'NonRes-sAll-mHVAC&Mot', 'HVAC and Motors', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.84', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('153', 'NonRes-sAll-mHVAC&Mot', 'HVAC and Motors', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.84', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('59', 'NonRes-sAll-mHVACctrls', 'HVAC/economizer controls', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC_SpCl', 'HV_Tech', 'EMS', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('147', 'NonRes-sAll-mHVACctrls', 'HVAC/economizer controls', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', 'HVAC_SpCl', 'HV_Tech', 'EMS', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('52', 'NonRes-sAll-mLtgCtrl', 'Other Lighting Controls', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.81', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('140', 'NonRes-sAll-mLtgCtrl', 'Other Lighting Controls', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.81', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('53', 'NonRes-sAll-mLtgCtrl-htr', 'Lighting controls', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', '', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('141', 'NonRes-sAll-mLtgCtrl-htr', 'Lighting controls', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', '', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('54', 'NonRes-sAll-mLtgExit-htr', 'LED Exit Signs', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtExit', 'Ltg_Wired', 'Exit_fixt', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('142', 'NonRes-sAll-mLtgExit-htr', 'LED Exit Signs', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtExit', 'Ltg_Wired', 'Exit_fixt', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('56', 'NonRes-sAll-mLtgOther-des', 'Other Lighting', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.81', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('144', 'NonRes-sAll-mLtgOther-des', 'Other Lighting', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.81', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('55', 'NonRes-sAll-mLtgOther-dn', 'Other Lighting - Delamping, LED exit signs and other high efficiency lighting sources', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', '', '', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.77', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('143', 'NonRes-sAll-mLtgOther-dn', 'Other Lighting - Delamping, LED exit signs and other high efficiency lighting sources', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', '', '', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.77', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('57', 'NonRes-sAll-mLtgOther-lrg', 'All Lighting Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', '', '', '', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.54', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('145', 'NonRes-sAll-mLtgOther-lrg', 'All Lighting Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', '', '', '', 'Any', 'Any', 'LargeCust', 'CustIncent', 'Any', 'Any', '0.64', '', 'Large Non Residential Customized Measures-Chapter 14', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('50', 'NonRes-sAll-mOccSens', 'Occupancy Sensors', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'OccSens', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.77', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('138', 'NonRes-sAll-mOccSens', 'Occupancy Sensors', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-Ctls', 'Ltg_Wired', 'OccSens', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.84', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('58', 'NonRes-sAll-mProgStat', 'Other HVAC - Variable speed drives, package systems, HVAC controls, programmable thermostats', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', '', '', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('146', 'NonRes-sAll-mProgStat', 'Other HVAC - Variable speed drives, package systems, HVAC controls, programmable thermostats', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'HVAC', '', '', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.50', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('84', 'NonRes-sAll-mRCelec', 'Electric Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Ex', 'ExMedLrgNR', 'RettroCom', 'Any', 'Any', '0.90', '', 'Non Residential Retrocommissioning- Chapter 15', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('172', 'NonRes-sAll-mRCelec', 'Electric Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Ex', 'ExMedLrgNR', 'RettroCom', 'Any', 'Any', '0.90', '', 'Non Residential Retrocommissioning- Chapter 15', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('85', 'NonRes-sAll-mRCgas', 'Gas Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Ex', 'ExMedLrgNR', 'RettroCom', 'Any', 'Any', '1.00', '', 'Non Residential Retrocommissioning- Chapter 15', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('173', 'NonRes-sAll-mRCgas', 'Gas Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Ex', 'ExMedLrgNR', 'RettroCom', 'Any', 'Any', '1.00', '', 'Non Residential Retrocommissioning- Chapter 15', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('64', 'NonRes-sAll-mRfg', 'All Refrigeration Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'ComRefrig', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.82', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('152', 'NonRes-sAll-mRfg', 'All Refrigeration Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'ComRefrig', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.82', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('63', 'NonRes-sAll-mRfg-DG', 'Door Gaskets', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'Cref-Disp', 'Refrig_Stor', 'Disp-DGC', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.76', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('151', 'NonRes-sAll-mRfg-DG', 'Door Gaskets', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'Cref-Disp', 'Refrig_Stor', 'Disp-DGC', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.76', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('62', 'NonRes-sAll-mRfg-SC', 'Strip Door Curtains', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Stor', 'StripCurt', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.46', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('150', 'NonRes-sAll-mRfg-SC', 'Strip Door Curtains', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'ComRefrig', 'CRef-Stor', 'Refrig_Stor', 'StripCurt', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.46', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('68', 'NonRes-sAll-mShellElec', 'All Building Shell Measures - Electric', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgEnv', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.87', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('156', 'NonRes-sAll-mShellElec', 'All Building Shell Measures - Electric', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgEnv', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.87', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('69', 'NonRes-sAll-mShellGas', 'All Building Shell Measures - Gas', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgEnv', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.93', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('157', 'NonRes-sAll-mShellGas', 'All Building Shell Measures - Gas', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'BldgEnv', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.93', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('67', 'NonRes-sAll-mSHW-des', 'Domestic Hot Water', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'SHW', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.82', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('155', 'NonRes-sAll-mSHW-des', 'Domestic Hot Water', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'SHW', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.82', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('66', 'NonRes-sAll-mSHW-dn', 'Domestic Hot Water - Clothes washers, boilers, process boilers and insulation', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.46', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('154', 'NonRes-sAll-mSHW-dn', 'Domestic Hot Water - Clothes washers, boilers, process boilers and insulation', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'SHW', 'SHW-Htg', 'WaterHtg_eq', '', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.46', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('48', 'NonRes-sAll-mT5T8', 'T5s and T8s, 4-foot and 8-foot lamps', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.78', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('136', 'NonRes-sAll-mT5T8', 'T5s and T8s, 4-foot and 8-foot lamps', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.78', '', 'Non Residential Prescriptive Rebates - Chapter 10', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('49', 'NonRes-sAll-mT8', 'T8s, 4-foot and 8-foot lamps', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('137', 'NonRes-sAll-mT8', 'T8s, 4-foot and 8-foot lamps', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'LinFluor_fixt', 'Any', 'Any', 'SmallHTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Non Residential Direct Install- Chapter 13', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('70', 'NonRes-sAll-mWB', 'Whole Building Measures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Bldg', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.70', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('158', 'NonRes-sAll-mWB', 'Whole Building Measures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Com', 'Bldg', '', '', '', 'Any', 'New', 'None', 'BldgDesInc', 'Any', 'Any', '0.70', '', 'Non Residential New Construction- Chapter 12', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('42', 'Res-Default', 'Default values for new measures or delivery methods where no previous NTG results are available.', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'None', 'AllDes', 'Any', 'Any', '0.80', '', 'Overview of DEER NTG Update Process - Chapter 1', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('130', 'Res-Default', 'Default values for new measures or delivery methods where no previous NTG results are available.', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'None', 'AllDes', 'Any', 'Any', '0.70', '', 'Overview of DEER NTG Update Process - Chapter 1', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('41', 'Res-Default-noval', 'New Measures not Otherwise Addressed OR Existing Direct Installed measures for Hard to Reach markets', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'VLowMarket', 'InnovDelivDI', 'Any', 'Any', null, '', '', '', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('129', 'Res-Default-noval', 'New Measures not Otherwise Addressed OR Existing Direct Installed measures for Hard to Reach markets', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Default', 'SelectCategory', 'Default', 'SelectTech', 'Any', 'Any', 'VLowMarket', 'InnovDelivDI', 'Any', 'Any', '0.85', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('3', 'Res-sAll-mCFLgt30-dn', 'CFL-screw in, >30 Watt excluding reflector/dimmable', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.75', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('91', 'Res-sAll-mCFLgt30-dn', 'CFL-screw in, >30 Watt excluding reflector/dimmable', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.75', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('4', 'Res-sAll-mCFLgt30-up', 'CFL-screw in, >30 Watt excluding reflector/dimmable', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('92', 'Res-sAll-mCFLgt30-up', 'CFL-screw in, >30 Watt excluding reflector/dimmable', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('2', 'Res-sAll-mCFLle30-dir', 'CFL-screw in, <=30 watt', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential Direct Install- Chapter 9', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('90', 'Res-sAll-mCFLle30-dir', 'CFL-screw in, <=30 watt', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential Direct Install- Chapter 9', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('1', 'Res-sAll-mCFLle30-up', 'CFL-screw in, <=30 watt', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.60', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('89', 'Res-sAll-mCFLle30-up', 'CFL-screw in, <=30 watt', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.60', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('5', 'Res-sAll-mCFLspec-dn', 'CFL-screw in - Specialty bulbs, Reflector/Dimmable', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.80', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('93', 'Res-sAll-mCFLspec-dn', 'CFL-screw in - Specialty bulbs, Reflector/Dimmable', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.80', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('6', 'Res-sAll-mCFLspec-up', 'CFL-screw in - Specialty bulbs, Reflector/Dimmable', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('94', 'Res-sAll-mCFLspec-up', 'CFL-screw in - Specialty bulbs, Reflector/Dimmable', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_ScrewIn', 'CFL_lamp', 'Any', 'Any', 'None', 'UpPreReb', 'Any', 'Any', '0.85', '', 'Residential Lighting- Chapter 2', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('11', 'Res-sAll-mCW15gtDOE', 'Clothes washer- 15% above DOE standard', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-Lndry', 'Clean_equip', 'CW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.85', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('99', 'Res-sAll-mCW15gtDOE', 'Clothes washer- 15% above DOE standard', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-Lndry', 'Clean_equip', 'CW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.85', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('10', 'Res-sAll-mCWgt172', 'Clothes washer >1.72 MEF', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-Lndry', 'Clean_equip', 'CW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.81', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('98', 'Res-sAll-mCWgt172', 'Clothes washer >1.72 MEF', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-Lndry', 'Clean_equip', 'CW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.81', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('17', 'Res-sAll-mDHWpipins', 'Pipe insulation', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'LiqCirc', 'PipeIns', 'Any', 'Any', 'HTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential Direct Install- Chapter 9', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('105', 'Res-sAll-mDHWpipins', 'Pipe insulation', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'LiqCirc', 'PipeIns', 'Any', 'Any', 'HTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential Direct Install- Chapter 9', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('16', 'Res-sAll-mDHWshwr', 'Low flow showerheads', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'WaterFixt', 'ShowerHd', 'Any', 'Any', 'HTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential Direct Install- Chapter 9', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('104', 'Res-sAll-mDHWshwr', 'Low flow showerheads', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Dist', 'WaterFixt', 'ShowerHd', 'Any', 'Any', 'HTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential Direct Install- Chapter 9', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('13', 'Res-sAll-mDW15gtStd', 'Dishwasher - 15% above current standard or E star', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Clean_equip', 'DW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.80', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('101', 'Res-sAll-mDW15gtStd', 'Dishwasher - 15% above current standard or E star', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Clean_equip', 'DW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.80', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('12', 'Res-sAll-mDW58to65ef', 'Dishwasher > .58 EF and <.65 EF', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Clean_equip', 'DW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.41', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('100', 'Res-sAll-mDW58to65ef', 'Dishwasher > .58 EF and <.65 EF', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Clean_equip', 'DW', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.41', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('9', 'Res-sAll-mFrzrRec', 'Freezer, Efficiency characteristics of recycled unit', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Refrig_Stor', 'Freezer', 'Any', 'Any', 'None', 'TurninRecyc', 'Any', 'Any', '0.70', '', 'Residential Appliance Recycling-Chapter 8', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('97', 'Res-sAll-mFrzrRec', 'Freezer, Efficiency characteristics of recycled unit', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Refrig_Stor', 'Freezer', 'Any', 'Any', 'None', 'TurninRecyc', 'Any', 'Any', '0.70', '', 'Residential Appliance Recycling-Chapter 8', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('7', 'Res-sAll-mRefg15', 'Refrigerator/Freezer- 15% Beyond current standard', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Refrig_Stor', 'RefrigFrz', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.75', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('95', 'Res-sAll-mRefg15', 'Refrigerator/Freezer- 15% Beyond current standard', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Refrig_Stor', 'RefrigFrz', 'Any', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.75', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('8', 'Res-sAll-mRefgRec', 'Refrigerator, Efficiency characteristics of recycled unit', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Refrig_Stor', 'RefrigFrz', 'Any', 'Any', 'None', 'TurninRecyc', 'Any', 'Any', '0.61', '', 'Residential Appliance Recycling-Chapter 8', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('96', 'Res-sAll-mRefgRec', 'Refrigerator, Efficiency characteristics of recycled unit', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Aplg', 'Aplg-KitAp', 'Refrig_Stor', 'RefrigFrz', 'Any', 'Any', 'None', 'TurninRecyc', 'Any', 'Any', '0.61', '', 'Residential Appliance Recycling-Chapter 8', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('32', 'Res-sMF-mBlrCtrls-afd', 'Boiler controls', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', '', '', '', 'MFM', 'Any', 'Afford', 'DownPreReb', 'Any', 'Any', '1.00', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('120', 'Res-sMF-mBlrCtrls-afd', 'Boiler controls', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', '', '', '', 'MFM', 'Any', 'Afford', 'DownPreReb', 'Any', 'Any', null, '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('31', 'Res-sMF-mBlrCtrls-mkt', 'Boiler controls', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', '', '', '', 'MFM', 'Any', 'MarkHous', 'DownPreReb', 'Any', 'Any', '0.81', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('119', 'Res-sMF-mBlrCtrls-mkt', 'Boiler controls', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', '', '', '', 'MFM', 'Any', 'MarkHous', 'DownPreReb', 'Any', 'Any', null, '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('30', 'Res-sMF-mCFL-afd', 'CFLs & hardwired fixtures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'CFL_fixt', 'MFM', 'Any', 'Afford', 'DownPreRebDI', 'Any', 'Any', '0.80', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('118', 'Res-sMF-mCFL-afd', 'CFLs & hardwired fixtures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'CFL_fixt', 'MFM', 'Any', 'Afford', 'DownPreRebDI', 'Any', 'Any', '0.81', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('29', 'Res-sMF-mCFL-mkt', 'CFLs & hardwired fixtures', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'CFL_fixt', 'MFM', 'Any', 'MarkHous', 'DirInstall', 'Any', 'Any', '0.76', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('117', 'Res-sMF-mCFL-mkt', 'CFLs & hardwired fixtures', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', 'Ltg-ILtGen', 'Ltg_Wired', 'CFL_fixt', 'MFM', 'Any', 'MarkHous', 'DirInstall', 'Any', 'Any', '0.76', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('35', 'Res-sMF-mHVAC_WH', 'HVAC/Water heating equipment replacement', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', '', '', '', 'MFM', 'Any', 'Afford', 'DownPreReb', 'Any', 'Any', '0.85', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('123', 'Res-sMF-mHVAC_WH', 'HVAC/Water heating equipment replacement', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', '', '', '', 'MFM', 'Any', 'Afford', 'DownPreReb', 'Any', 'Any', '0.85', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('34', 'Res-sMF-mProgTstat-afd', 'Programmable thermostats', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'MFM', 'Any', 'Afford', 'DirInstall', 'Any', 'Any', '0.86', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('122', 'Res-sMF-mProgTstat-afd', 'Programmable thermostats', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'MFM', 'Any', 'Afford', 'DirInstall', 'Any', 'Any', '0.86', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('33', 'Res-sMF-mProgTstat-mkt', 'Programmable thermostats', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'MFM', 'Any', 'MarkHous', 'DirInstall', 'Any', 'Any', '0.79', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('121', 'Res-sMF-mProgTstat-mkt', 'Programmable thermostats', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'MFM', 'Any', 'MarkHous', 'DirInstall', 'Any', 'Any', '0.79', '', 'Residential Multifamily - Chapter 5', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('37', 'Res-sMF-mWBperf', 'Whole building', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', '', '', 'SFM', 'New', 'None', 'CustReb', 'Any', 'Any', '0.50', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('125', 'Res-sMF-mWBperf', 'Whole building', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'SFM', 'New', 'None', 'CustReb', 'Any', 'Any', '0.50', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('18', 'Res-sSF-mACgt14-dn', 'Central AC>14 SEER', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.67', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('106', 'Res-sSF-mACgt14-dn', 'Central AC>14 SEER', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.67', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('20', 'Res-sSF-mACgt14-ext', 'Central AC >14 SEER', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'ExtFinance', 'Any', 'Any', '0.63', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('108', 'Res-sSF-mACgt14-ext', 'Central AC >14 SEER', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'ExtFinance', 'Any', 'Any', '0.63', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('19', 'Res-sSF-mACgt15', 'Central AC>15 SEER', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.80', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('107', 'Res-sSF-mACgt15', 'Central AC>15 SEER', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpCl', 'dxAC_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.80', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('39', 'Res-sSF-mAudit', 'On site Audit, Phone, or Mail in Audit', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', '', '', 'SFM', 'New', 'None', 'OnSiteAudit', 'Any', 'Any', '0.80', '', 'Residential Audits - Chapter 8', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('127', 'Res-sSF-mAudit', 'On site Audit, Phone, or Mail in Audit', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'SFM', 'New', 'None', 'OnSiteAudit', 'Any', 'Any', '0.80', '', 'Residential Audits - Chapter 8', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('15', 'Res-sSF-mDHWgt62', 'Water Heater EF >.62', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WtrHtg_eq', 'Stor_EF', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.58', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('103', 'Res-sSF-mDHWgt62', 'Water Heater EF >.62', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'SHW', 'SHW-Htg', 'WtrHtg_eq', 'Stor_EF', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.58', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('27', 'Res-sSF-mDuctSeal', 'Duct Sealing', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-Vent', 'HV_AirDist', 'DuctSysR', 'SFM', 'Any', 'None', 'FreeTURepair', 'Any', 'Any', '0.78', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('115', 'Res-sSF-mDuctSeal', 'Duct Sealing', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-Vent', 'HV_AirDist', 'DuctSysR', 'SFM', 'Any', 'None', 'FreeTURepair', 'Any', 'Any', '0.78', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('22', 'Res-sSF-mFurn90af', 'Gas Furnace - 90% AFUE', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpHt', 'SpaceHtg_eq', 'GasFurnace', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.60', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('110', 'Res-sSF-mFurn90af', 'Gas Furnace - 90% AFUE', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-SpHt', 'SpaceHtg_eq', 'GasFurnace', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.60', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('21', 'Res-sSF-mHPes', 'Heat Pump - Energy Star', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.55', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('109', 'Res-sSF-mHPes', 'Heat Pump - Energy Star', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-HtCl', 'dxHP_equip', 'SpltSEER', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.55', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('26', 'Res-sSF-mHVACDiag', 'HVAC diagnostic', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', '', '', 'SFM', 'Any', 'None', 'FreeTURepair', 'Any', 'Any', '0.78', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('114', 'Res-sSF-mHVACDiag', 'HVAC diagnostic', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'SFM', 'Any', 'None', 'FreeTURepair', 'Any', 'Any', '0.78', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('38', 'Res-sSF-mLtg', 'Lighting', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', '', '', '', 'SFM', 'New', 'None', 'PrescipReb', 'Any', 'Any', '0.62', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('126', 'Res-sSF-mLtg', 'Lighting', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Ltg', '', '', '', 'SFM', 'New', 'None', 'PrescipReb', 'Any', 'Any', '0.62', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('40', 'Res-sSF-mOnlineAudit', 'On line audit', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', '', '', 'SFM', 'New', 'None', 'OnLineAudit', 'Any', 'Any', '0.80', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('128', 'Res-sSF-mOnlineAudit', 'On line audit', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'SFM', 'New', 'None', 'OnLineAudit', 'Any', 'Any', '0.80', '', '', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('14', 'Res-sSF-mPPump2spd', 'Pool pump-2 Speed', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Rec', 'Rec-Pool', 'LiqCirc', 'PmpMtr', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.69', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('102', 'Res-sSF-mPPump2spd', 'Pool pump-2 Speed', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'Rec', 'Rec-Pool', 'LiqCirc', 'PmpMtr', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.69', '', 'Residential Appliances - Chapter 4', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('24', 'Res-sSF-mProgTstat', 'Programmable thermostats', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.49', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('112', 'Res-sSF-mProgTstat', 'Programmable thermostats', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.49', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('25', 'Res-sSF-mProgTstat-htr', 'Programmable thermostats', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'SFM', 'Any', 'HTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('113', 'Res-sSF-mProgTstat-htr', 'Programmable thermostats', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'HVAC', 'HVAC-EnvCtls', 'HV_Tech', 'TStat', 'SFM', 'Any', 'HTR', 'DirInstall', 'Any', 'Any', '0.85', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('23', 'Res-sSF-mShellIns', 'Wall and Ceiling Insulation', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.70', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('111', 'Res-sSF-mShellIns', 'Wall and Ceiling Insulation', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Opaq', 'BldgShell', '', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.70', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('36', 'Res-sSF-mWBperf', 'Whole building', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', '', '', 'SFM', 'New', 'None', 'CustReb', 'Any', 'Any', '0.48', '', 'Residential New Construction - Chapter 6', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('124', 'Res-sSF-mWBperf', 'Whole building', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgSys', 'Diag', 'NA', 'NA', 'SFM', 'New', 'None', 'CustReb', 'Any', 'Any', '0.48', '', 'Residential New Construction - Chapter 6', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('28', 'Res-sSF-mWindow', 'Windows-SHGC, Shading coefficient 0.4', '06-08 Update', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Fen', 'Fenest', '', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.55', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);
INSERT INTO "costeff"."NTGR" VALUES ('116', 'Res-sSF-mWindow', 'Windows-SHGC, Shading coefficient 0.4', '09-11 Planning', 'DEER2008', '0001-01-01 00:00:00', 'Res', 'BldgEnv', 'Env-Fen', 'Fenest', '', 'SFM', 'Any', 'None', 'DownPreReb', 'Any', 'Any', '0.55', '', 'Residential HVAC - Chapter 3', 'Standard', 'Any', null, null, null);

-- ----------------------------
-- Alter Sequences Owned By 
-- ----------------------------

-- ----------------------------
-- Primary Key structure for table "costeff"."CostAdjust"
-- ----------------------------
ALTER TABLE "costeff"."CostAdjust" ADD PRIMARY KEY ("Version", "AdjustType", "Location");

-- ----------------------------
-- Indexes structure for table EUL
-- ----------------------------
CREATE UNIQUE INDEX "EUL_index" ON "costeff"."EUL" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "costeff"."EUL"
-- ----------------------------
ALTER TABLE "costeff"."EUL" ADD PRIMARY KEY ("EUL_ID", "Version", "BldgType", "BldgLoc");

-- ----------------------------
-- Primary Key structure for table "costeff"."GSIA"
-- ----------------------------
ALTER TABLE "costeff"."GSIA" ADD PRIMARY KEY ("Index");

-- ----------------------------
-- Primary Key structure for table "costeff"."LaborRates"
-- ----------------------------
ALTER TABLE "costeff"."LaborRates" ADD PRIMARY KEY ("Code");

-- ----------------------------
-- Indexes structure for table NTGR
-- ----------------------------
CREATE UNIQUE INDEX "NTG_index" ON "costeff"."NTGR" USING btree ("Index");

-- ----------------------------
-- Primary Key structure for table "costeff"."NTGR"
-- ----------------------------
ALTER TABLE "costeff"."NTGR" ADD PRIMARY KEY ("NTG_ID", "Version", "BldgType", "BldgVint");
