-- Function to weight the residential meas_impacts_wtd records for a given measure_id that has multiple HVAC types. 
--  results are given a BldgHVAC value of rWtd, 
--  existing results for the specified techid are deleted if they exist before new results are added
-- 
-- Note: depends on meas_impacts_wtd for the simulation results and support.wts_res_hvac for the weights
--       results written to meas_impacts_wtd
DECLARE
    ImpactsMatrix support."measure_matrix_ip"%ROWTYPE;
    WtdImpactsRec  simresults."meas_impacts_wtd"%ROWTYPE;
    IOU TEXT;
    NumRecs INTEGER;
    TotProc INTEGER;
    Wt FLOAT;
    sumWt FLOAT;
    measarea FLOAT;
    numunits FLOAT;
    apre_kwh_tot FLOAT;
    apre_kwh_ltg FLOAT;
    apre_kwh_task FLOAT;
    apre_kwh_equip FLOAT;
    apre_kwh_htg FLOAT;
    apre_kwh_clg FLOAT;
    apre_kwh_twr FLOAT;
    apre_kwh_aux FLOAT;
    apre_kwh_vent FLOAT;
    apre_kwh_venthtg FLOAT;
    apre_kwh_ventclg FLOAT;
    apre_kwh_refg FLOAT;
    apre_kwh_hpsup FLOAT;
    apre_kwh_ext FLOAT;
    apre_kwh_shw FLOAT;
    apre_thm_tot FLOAT;
    apre_thm_equip FLOAT;
    apre_thm_htg FLOAT;
    apre_thm_shw FLOAT;
    apre_kwpp_tot FLOAT;
    apre_kwpp_ltg FLOAT;
    apre_kwpp_equip FLOAT;
    astd_kwh_tot FLOAT;
    astd_kwh_ltg FLOAT;
    astd_kwh_task FLOAT;
    astd_kwh_equip FLOAT;
    astd_kwh_htg FLOAT;
    astd_kwh_clg FLOAT;
    astd_kwh_twr FLOAT;
    astd_kwh_aux FLOAT;
    astd_kwh_vent FLOAT;
    astd_kwh_venthtg FLOAT;
    astd_kwh_ventclg FLOAT;
    astd_kwh_refg FLOAT;
    astd_kwh_hpsup FLOAT;
    astd_kwh_ext FLOAT;
    astd_kwh_shw FLOAT;
    astd_thm_tot FLOAT;
    astd_thm_equip FLOAT;
    astd_thm_htg FLOAT;
    astd_thm_shw FLOAT;
    astd_kwpp_tot FLOAT;
    astd_kwpp_ltg FLOAT;
    astd_kwpp_equip FLOAT;
BEGIN
 -- Delete all weighted results for the specified measure_id:
 DELETE FROM meas_impacts_wtd WHERE meas_impacts_wtd.measure_id = $1 and meas_impacts_wtd.bldghvac = 'rWtd';
 TotProc = 0;
 FOR ImpactsMatrix IN 
  -- Load the ImpactsMatrix with all combinations of bldgtype, vint and loc for the given MeasureID.  
  SELECT DISTINCT measure_id as "MeasureID", bldgtype,bldgvint,bldgloc,'rWtd' as bldghvac,'1' as tstat 
    FROM "simresults"."meas_impacts_wtd" 
    WHERE measure_id = $1 and tstat = -1
    ORDER BY bldgtype,bldgvint,bldgloc
  LOOP
    -- the simulation results are not PA specific, but the weights are, so loop thru all PAs for each set of results
    FOR IOU IN (SELECT DISTINCT "pa" as "IOU" from support.wts_res_hvac)
    LOOP
       TotProc = TotProc + 1;
       -- Initialize the numeric results values:
       sumWt = 0;
       measarea = 0;
       numunits = 0;
       apre_kwh_tot = 0;
       apre_kwh_ltg = 0;
       apre_kwh_task = 0;
       apre_kwh_equip = 0;
       apre_kwh_htg = 0;
       apre_kwh_clg = 0;
       apre_kwh_twr = 0;
       apre_kwh_aux = 0;
       apre_kwh_vent = 0;
       apre_kwh_venthtg = 0;
       apre_kwh_ventclg = 0;
       apre_kwh_refg = 0;
       apre_kwh_hpsup = 0;
       apre_kwh_ext = 0;
       apre_kwh_shw = 0;
       apre_thm_tot = 0;
       apre_thm_equip = 0;
       apre_thm_htg = 0;
       apre_thm_shw = 0;
       apre_kwpp_tot = 0;
       apre_kwpp_ltg = 0;
       apre_kwpp_equip = 0;
       astd_kwh_tot = 0;
       astd_kwh_ltg = 0;
       astd_kwh_task = 0;
       astd_kwh_equip = 0;
       astd_kwh_htg = 0;
       astd_kwh_clg = 0;
       astd_kwh_twr = 0;
       astd_kwh_aux = 0;
       astd_kwh_vent = 0;
       astd_kwh_venthtg = 0;
       astd_kwh_ventclg = 0;
       astd_kwh_refg = 0;
       astd_kwh_hpsup = 0;
       astd_kwh_ext = 0;
       astd_kwh_shw = 0;
       astd_thm_tot = 0;
       astd_thm_equip = 0;
       astd_thm_htg = 0;
       astd_thm_shw = 0;
       astd_kwpp_tot = 0;
       astd_kwpp_ltg = 0;
       astd_kwpp_equip = 0;
       -- Get the simulation results for each of the HVAC types associated with the group:
       FOR WtdImpactsRec IN SELECT * FROM meas_impacts_wtd
        WHERE  meas_impacts_wtd.measure_id = ImpactsMatrix."MeasureID"
          and  meas_impacts_wtd.bldgtype = ImpactsMatrix.bldgtype
          and  meas_impacts_wtd.bldgvint = ImpactsMatrix.bldgvint  
          and  meas_impacts_wtd.bldgloc  = ImpactsMatrix.bldgloc
          and  meas_impacts_wtd.bldghvac <> 'rWtd'
          and  meas_impacts_wtd.tstat = -1
        LOOP
         -- get the weight associated with the HVAC type:
         SELECT "wtval" INTO Wt FROM support.wts_res_hvac WHERE
            wts_res_hvac.bldgtype = WtdImpactsRec.bldgtype AND
            wts_res_hvac.bldgloc  = WtdImpactsRec.bldgloc AND
            wts_res_hvac.bldghvac = WtdImpactsRec.bldghvac AND
            wts_res_hvac.pa       = IOU;
         sumWt = sumWt + Wt;
         IF Wt IS NOT NULL THEN
           measarea         = measarea         + WtdImpactsRec.measarea         * Wt;
           numunits         = numunits         + WtdImpactsRec.numunits         * Wt;
           apre_kwh_tot     = apre_kwh_tot     + WtdImpactsRec.apre_kwh_tot     * Wt;
           apre_kwh_ltg     = apre_kwh_ltg     + WtdImpactsRec.apre_kwh_ltg     * Wt;
           apre_kwh_task    = apre_kwh_task    + WtdImpactsRec.apre_kwh_task    * Wt;
           apre_kwh_equip   = apre_kwh_equip   + WtdImpactsRec.apre_kwh_equip   * Wt;
           apre_kwh_htg     = apre_kwh_htg     + WtdImpactsRec.apre_kwh_htg     * Wt;
           apre_kwh_clg     = apre_kwh_clg     + WtdImpactsRec.apre_kwh_clg     * Wt;
           apre_kwh_twr     = apre_kwh_twr     + WtdImpactsRec.apre_kwh_twr     * Wt;
           apre_kwh_aux     = apre_kwh_aux     + WtdImpactsRec.apre_kwh_aux     * Wt;
           apre_kwh_vent    = apre_kwh_vent    + WtdImpactsRec.apre_kwh_vent    * Wt;
           apre_kwh_venthtg = apre_kwh_venthtg + WtdImpactsRec.apre_kwh_venthtg * Wt;
           apre_kwh_ventclg = apre_kwh_ventclg + WtdImpactsRec.apre_kwh_ventclg * Wt;
           apre_kwh_refg    = apre_kwh_refg    + WtdImpactsRec.apre_kwh_refg    * Wt;
           apre_kwh_hpsup   = apre_kwh_hpsup   + WtdImpactsRec.apre_kwh_hpsup   * Wt;
           apre_kwh_shw     = apre_kwh_shw     + WtdImpactsRec.apre_kwh_shw     * Wt;
           apre_kwh_ext     = apre_kwh_ext     + WtdImpactsRec.apre_kwh_ext     * Wt;
           apre_thm_tot     = apre_thm_tot     + WtdImpactsRec.apre_thm_tot     * Wt;
           apre_thm_equip   = apre_thm_equip   + WtdImpactsRec.apre_thm_equip   * Wt;
           apre_thm_htg     = apre_thm_htg     + WtdImpactsRec.apre_thm_htg     * Wt;
           apre_thm_shw     = apre_thm_shw     + WtdImpactsRec.apre_thm_shw     * Wt;
           apre_kwpp_tot    = apre_kwpp_tot    + WtdImpactsRec.apre_kwpp_tot    * Wt;
           apre_kwpp_ltg    = apre_kwpp_ltg    + WtdImpactsRec.apre_kwpp_ltg    * Wt;
           apre_kwpp_equip  = apre_kwpp_equip  + WtdImpactsRec.apre_kwpp_equip  * Wt;

           astd_kwh_tot     = astd_kwh_tot     + WtdImpactsRec.astd_kwh_tot     * Wt;
           astd_kwh_ltg     = astd_kwh_ltg     + WtdImpactsRec.astd_kwh_ltg     * Wt;
           astd_kwh_task    = astd_kwh_task    + WtdImpactsRec.astd_kwh_task    * Wt;
           astd_kwh_equip   = astd_kwh_equip   + WtdImpactsRec.astd_kwh_equip   * Wt;
           astd_kwh_htg     = astd_kwh_htg     + WtdImpactsRec.astd_kwh_htg     * Wt;
           astd_kwh_clg     = astd_kwh_clg     + WtdImpactsRec.astd_kwh_clg     * Wt;
           astd_kwh_twr     = astd_kwh_twr     + WtdImpactsRec.astd_kwh_twr     * Wt;
           astd_kwh_aux     = astd_kwh_aux     + WtdImpactsRec.astd_kwh_aux     * Wt;
           astd_kwh_vent    = astd_kwh_vent    + WtdImpactsRec.astd_kwh_vent    * Wt;
           astd_kwh_venthtg = astd_kwh_venthtg + WtdImpactsRec.astd_kwh_venthtg * Wt;
           astd_kwh_ventclg = astd_kwh_ventclg + WtdImpactsRec.astd_kwh_ventclg * Wt;
           astd_kwh_refg    = astd_kwh_refg    + WtdImpactsRec.astd_kwh_refg    * Wt;
           astd_kwh_hpsup   = astd_kwh_hpsup   + WtdImpactsRec.astd_kwh_hpsup   * Wt;
           astd_kwh_shw     = astd_kwh_shw     + WtdImpactsRec.astd_kwh_shw     * Wt;
           astd_kwh_ext     = astd_kwh_ext     + WtdImpactsRec.astd_kwh_ext     * Wt;
           astd_thm_tot     = astd_thm_tot     + WtdImpactsRec.astd_thm_tot     * Wt;
           astd_thm_equip   = astd_thm_equip   + WtdImpactsRec.astd_thm_equip   * Wt;
           astd_thm_htg     = astd_thm_htg     + WtdImpactsRec.astd_thm_htg     * Wt;
           astd_thm_shw     = astd_thm_shw     + WtdImpactsRec.astd_thm_shw     * Wt;
           astd_kwpp_tot    = astd_kwpp_tot    + WtdImpactsRec.astd_kwpp_tot    * Wt;
           astd_kwpp_ltg    = astd_kwpp_ltg    + WtdImpactsRec.astd_kwpp_ltg    * Wt;
           astd_kwpp_equip  = astd_kwpp_equip  + WtdImpactsRec.astd_kwpp_equip  * Wt;
           END IF;
        END LOOP; -- through all HVAC types
      If sumWt > 0 THEN
      INSERT INTO meas_impacts_wtd VALUES 
         (DEFAULT,WtdImpactsRec.measure_id,ImpactsMatrix.bldgtype,ImpactsMatrix.bldgvint,ImpactsMatrix.bldgloc,'rWtd',-1,WtdImpactRec.normunit,
          round((numunits   /sumWt)::NUMERIC(15,3),2),
          round((measarea   /sumWt)::NUMERIC(15,1),2),
          case when apre_kwh_tot     = 0 then 0 else round((apre_kwh_tot/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_tot/sumWt)))))::INT) end, 
          case when apre_kwh_ltg     = 0 then 0 else round((apre_kwh_ltg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_ltg/sumWt)))))::INT) end, 
          case when apre_kwh_task    = 0 then 0 else round((apre_kwh_task/sumWt)::NUMERIC(15,3)   ,(2-floor(log(abs((apre_kwh_task/sumWt)))))::INT) end, 
          case when apre_kwh_equip   = 0 then 0 else round((apre_kwh_equip/sumWt)::NUMERIC(15,3)  ,(2-floor(log(abs((apre_kwh_equip/sumWt)))))::INT) end, 
          case when apre_kwh_htg     = 0 then 0 else round((apre_kwh_htg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_htg/sumWt)))))::INT) end, 
          case when apre_kwh_clg     = 0 then 0 else round((apre_kwh_clg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_clg/sumWt)))))::INT) end, 
          case when apre_kwh_twr     = 0 then 0 else round((apre_kwh_twr/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_twr/sumWt)))))::INT) end, 
          case when apre_kwh_aux     = 0 then 0 else round((apre_kwh_aux/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_aux/sumWt)))))::INT) end, 
          case when apre_kwh_vent    = 0 then 0 else round((apre_kwh_vent/sumWt)::NUMERIC(15,3)   ,(2-floor(log(abs((apre_kwh_vent/sumWt)))))::INT) end, 
          case when apre_kwh_venthtg = 0 then 0 else round((apre_kwh_venthtg/sumWt)::NUMERIC(15,3),(2-floor(log(abs((apre_kwh_venthtg/sumWt)))))::INT) end, 
          case when apre_kwh_ventclg = 0 then 0 else round((apre_kwh_ventclg/sumWt)::NUMERIC(15,3),(2-floor(log(abs((apre_kwh_ventclg)/sumWt))))::INT) end, 
          case when apre_kwh_refg    = 0 then 0 else round((apre_kwh_refg/sumWt)::NUMERIC(15,3)   ,(2-floor(log(abs((apre_kwh_refg/sumWt)))))::INT) end, 
          case when apre_kwh_hpsup   = 0 then 0 else round((apre_kwh_hpsup/sumWt)::NUMERIC(15,3)  ,(2-floor(log(abs((apre_kwh_hpsup/sumWt)))))::INT) end, 
          case when apre_kwh_shw     = 0 then 0 else round((apre_kwh_shw/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_shw/sumWt)))))::INT) end, 
          case when apre_kwh_ext     = 0 then 0 else round((apre_kwh_ext/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_kwh_ext/sumWt)))))::INT) end, 
          case when apre_thm_tot     = 0 then 0 else round((apre_thm_tot/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_thm_tot/sumWt)))))::INT) end, 
          case when apre_thm_equip   = 0 then 0 else round((apre_thm_equip/sumWt)::NUMERIC(15,3)  ,(2-floor(log(abs((apre_thm_equip/sumWt)))))::INT) end, 
          case when apre_thm_htg     = 0 then 0 else round((apre_thm_htg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_thm_htg/sumWt)))))::INT) end, 
          case when apre_thm_shw     = 0 then 0 else round((apre_thm_shw/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((apre_thm_shw/sumWt)))))::INT) end, 
          case when apre_kwpp_tot    = 0 then 0 else round((apre_kwpp_tot/sumWt)::NUMERIC(15,6)   ,(2-floor(log(abs((apre_kwpp_tot/sumWt)))))::INT) end, 
          case when apre_kwpp_ltg    = 0 then 0 else round((apre_kwpp_ltg/sumWt)::NUMERIC(15,6)   ,(2-floor(log(abs((apre_kwpp_ltg/sumWt)))))::INT) end, 
          case when apre_kwpp_equip  = 0 then 0 else round((apre_kwpp_equip/sumWt)::NUMERIC(15,6) ,(2-floor(log(abs((apre_kwpp_equip/sumWt)))))::INT) end, 
          -- above standard/code impacts:
          case when astd_kwh_tot     = 0 then 0 else round((astd_kwh_tot/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_tot/sumWt)))))::INT) end, 
          case when astd_kwh_ltg     = 0 then 0 else round((astd_kwh_ltg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_ltg/sumWt)))))::INT) end, 
          case when astd_kwh_task    = 0 then 0 else round((astd_kwh_task/sumWt)::NUMERIC(15,3)   ,(2-floor(log(abs((astd_kwh_task/sumWt)))))::INT) end, 
          case when astd_kwh_equip   = 0 then 0 else round((astd_kwh_equip/sumWt)::NUMERIC(15,3)  ,(2-floor(log(abs((astd_kwh_equip/sumWt)))))::INT) end, 
          case when astd_kwh_htg     = 0 then 0 else round((astd_kwh_htg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_htg/sumWt)))))::INT) end, 
          case when astd_kwh_clg     = 0 then 0 else round((astd_kwh_clg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_clg/sumWt)))))::INT) end, 
          case when astd_kwh_twr     = 0 then 0 else round((astd_kwh_twr/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_twr/sumWt)))))::INT) end, 
          case when astd_kwh_aux     = 0 then 0 else round((astd_kwh_aux/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_aux/sumWt)))))::INT) end, 
          case when astd_kwh_vent    = 0 then 0 else round((astd_kwh_vent/sumWt)::NUMERIC(15,3)   ,(2-floor(log(abs((astd_kwh_vent/sumWt)))))::INT) end, 
          case when astd_kwh_venthtg = 0 then 0 else round((astd_kwh_venthtg/sumWt)::NUMERIC(15,3),(2-floor(log(abs((astd_kwh_venthtg/sumWt)))))::INT) end, 
          case when astd_kwh_ventclg = 0 then 0 else round((astd_kwh_ventclg/sumWt)::NUMERIC(15,3),(2-floor(log(abs((astd_kwh_ventclg)/sumWt))))::INT) end, 
          case when astd_kwh_refg    = 0 then 0 else round((astd_kwh_refg/sumWt)::NUMERIC(15,3)   ,(2-floor(log(abs((astd_kwh_refg/sumWt)))))::INT) end, 
          case when astd_kwh_hpsup   = 0 then 0 else round((astd_kwh_hpsup/sumWt)::NUMERIC(15,3)  ,(2-floor(log(abs((astd_kwh_hpsup/sumWt)))))::INT) end, 
          case when astd_kwh_shw     = 0 then 0 else round((astd_kwh_shw/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_shw/sumWt)))))::INT) end, 
          case when astd_kwh_ext     = 0 then 0 else round((astd_kwh_ext/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_kwh_ext/sumWt)))))::INT) end, 
          case when astd_thm_tot     = 0 then 0 else round((astd_thm_tot/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_thm_tot/sumWt)))))::INT) end, 
          case when astd_thm_equip   = 0 then 0 else round((astd_thm_equip/sumWt)::NUMERIC(15,3)  ,(2-floor(log(abs((astd_thm_equip/sumWt)))))::INT) end, 
          case when astd_thm_htg     = 0 then 0 else round((astd_thm_htg/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_thm_htg/sumWt)))))::INT) end, 
          case when astd_thm_shw     = 0 then 0 else round((astd_thm_shw/sumWt)::NUMERIC(15,3)    ,(2-floor(log(abs((astd_thm_shw/sumWt)))))::INT) end, 
          case when astd_kwpp_tot    = 0 then 0 else round((astd_kwpp_tot/sumWt)::NUMERIC(15,6)   ,(2-floor(log(abs((astd_kwpp_tot/sumWt)))))::INT) end, 
          case when astd_kwpp_ltg    = 0 then 0 else round((astd_kwpp_ltg/sumWt)::NUMERIC(15,6)   ,(2-floor(log(abs((astd_kwpp_ltg/sumWt)))))::INT) end, 
          case when astd_kwpp_equip  = 0 then 0 else round((astd_kwpp_equip/sumWt)::NUMERIC(15,6) ,(2-floor(log(abs((astd_kwpp_equip/sumWt)))))::INT) end, 
          '',
          IOU);
      END IF;
      END LOOP; -- for all four PAs
  END LOOP;
 RETURN TotProc;
END;
