-- Function to weight the residential tech_results records based on the tstat 
--  results are added to tech_results_wtd table, 
--  existing results for a specific set of primary keys are deleted if they exist before new results are added
--  if tstat 1,2,3,4,5 don't exist for given primary keys, the weighted record is written with tstat = -9 indicating an error in processing
--  if weighting is successful, the weighted record has tstat = -1
--  Sim Qualifiers of "NA" are coverted to "None" in the weighted results table (for consistency with other tables)
-- Note: should run "Delete Duplicated Records in tech_results" query prior to running this query.
DECLARE
    TechResRec simresults."tech_results"%ROWTYPE;
    WtdResRec  simresults."tech_results_wtd"%ROWTYPE;
    NumTstats INTEGER;
    NumRecs INTEGER;
    TotProc INTEGER; 
    Wt FLOAT;
    sumWt FLOAT;
    measarea FLOAT;
    numunits FLOAT;
    kwh_tot FLOAT;
    kwh_ltg FLOAT;
    kwh_task FLOAT;
    kwh_equip FLOAT;
    kwh_htg FLOAT;
    kwh_clg FLOAT;
    kwh_twr FLOAT;
    kwh_aux FLOAT;
    kwh_vent FLOAT;
    kwh_venthtg FLOAT;
    kwh_ventclg FLOAT;
    kwh_refg FLOAT;
    kwh_hpsup FLOAT;
    kwh_ext FLOAT;
    kwh_shw FLOAT;
    thm_tot FLOAT;
    thm_equip FLOAT;
    thm_htg FLOAT;
    thm_shw FLOAT;
    kwpp_tot FLOAT;
    kwpp_ltg FLOAT;
    kwpp_equip FLOAT;
BEGIN
 TotProc = 0;
 FOR TechResRec IN SELECT * FROM tech_results 
  WHERE tstat = 1 
     and techrefid in (
       SELECT DISTINCT "StdTechID" as techrefid 
        FROM support.measure_matrix_ip 
        JOIN simresults.msrs2proc on measure_matrix_ip."MeasureID" = simresults.msrs2proc.measure_id and simresults.msrs2proc.include
       UNION
       SELECT DISTINCT "MsrTechID" as techrefid   
        FROM support.measure_matrix_ip 
        JOIN simresults.msrs2proc on measure_matrix_ip."MeasureID" = simresults.msrs2proc.measure_id and simresults.msrs2proc.include
       UNION
       SELECT DISTINCT "PreTechID" as techrefid   
        FROM support.measure_matrix_ip 
        JOIN simresults.msrs2proc on measure_matrix_ip."MeasureID" = simresults.msrs2proc.measure_id and simresults.msrs2proc.include)
    -- and bldgtype = 'DMo' 
    -- and techrefid LIKE 'Furnace-%'
  LOOP
    -- Delete any existing result for the qualifying records
    DELETE FROM tech_results_wtd  
      WHERE  tech_results_wtd.techrefid = TechResRec.techrefid
        and  tech_results_wtd.simqual  = TechResRec.simqual
        and  tech_results_wtd.bldgtype = TechResRec.bldgtype
        and  tech_results_wtd.bldgvint = TechResRec.bldgvint  
        and  tech_results_wtd.bldgloc  = TechResRec.bldgloc
        and  tech_results_wtd.bldghvac = TechResRec.bldghvac;
    -- verify that there are 5 stats (1 - 5) to work with
    SELECT COUNT(*) Into NumTstats FROM tech_results
        WHERE  tech_results.techrefid = TechResRec.techrefid
        and  tech_results.simqual  = TechResRec.simqual
        and  tech_results.bldgtype = TechResRec.bldgtype
        and  tech_results.bldgvint = TechResRec.bldgvint  
        and  tech_results.bldgloc  = TechResRec.bldgloc
        and  tech_results.bldghvac = TechResRec.bldghvac 
        and  tech_results.tstat > 0 and tech_results.tstat < 6;
    IF NumTstats = 5 THEN
       TotProc = TotProc + 1;
       sumWt = 0;
       measarea = 0;
       numunits = 0;
       kwh_tot = 0;
       kwh_ltg = 0;
       kwh_task = 0;
       kwh_equip = 0;
       kwh_htg = 0;
       kwh_clg = 0;
       kwh_twr = 0;
       kwh_aux = 0;
       kwh_vent = 0;
       kwh_venthtg = 0;
       kwh_ventclg = 0;
       kwh_refg = 0;
       kwh_hpsup = 0;
       kwh_ext = 0;
       kwh_shw = 0;
       thm_tot = 0;
       thm_equip = 0;
       thm_htg = 0;
       thm_shw = 0;
       kwpp_tot = 0;
       kwpp_ltg = 0;
       kwpp_equip = 0;
       FOR WtdResRec IN SELECT * FROM tech_results 
        WHERE  tech_results.techrefid = TechResRec.techrefid
        and  tech_results.simqual  = TechResRec.simqual
        and  tech_results.bldgtype = TechResRec.bldgtype
        and  tech_results.bldgvint = TechResRec.bldgvint  
        and  tech_results.bldgloc  = TechResRec.bldgloc
        and  tech_results.bldghvac = TechResRec.bldghvac 
        and  tech_results.tstat > 0 and tech_results.tstat < 6
        LOOP
         SELECT tstatwt INTO Wt FROM reststatwt WHERE
            reststatwt.bldgtype = WtdResRec.bldgtype AND
            reststatwt.bldgvint = WtdResRec.bldgvint AND
            reststatwt.bldgloc  = WtdResRec.bldgloc AND
            reststatwt.tstat    = WtdResRec.tstat;
         sumWt = sumWt + Wt;
         IF Wt IS NULL THEN
           RAISE EXCEPTION 'no Wt found for %', WtdResRec.bldgtype||':'||WtdResRec.bldgvint||':'||WtdResRec.bldgloc||':'||WtdResRec.tstat;
           END IF;
         measarea    = measarea    + WtdResRec.measarea    * Wt;
         numunits    = numunits    + WtdResRec.numunits    * Wt;
         kwh_tot     = kwh_tot     + WtdResRec.kwh_tot     * Wt;
         kwh_ltg     = kwh_ltg     + WtdResRec.kwh_ltg     * Wt;
         kwh_task    = kwh_task    + WtdResRec.kwh_task    * Wt;
         kwh_equip   = kwh_equip   + WtdResRec.kwh_equip   * Wt;
         kwh_htg     = kwh_htg     + WtdResRec.kwh_htg     * Wt;
         kwh_clg     = kwh_clg     + WtdResRec.kwh_clg     * Wt;
         kwh_twr     = kwh_twr     + WtdResRec.kwh_twr     * Wt;
         kwh_aux     = kwh_aux     + WtdResRec.kwh_aux     * Wt;
         kwh_vent    = kwh_vent    + WtdResRec.kwh_vent    * Wt;
         kwh_venthtg = kwh_venthtg + WtdResRec.kwh_venthtg * Wt;
         kwh_ventclg = kwh_ventclg + WtdResRec.kwh_ventclg * Wt;
         kwh_refg    = kwh_refg    + WtdResRec.kwh_refg    * Wt;
         kwh_hpsup   = kwh_hpsup   + WtdResRec.kwh_hpsup   * Wt;
         kwh_shw     = kwh_shw     + WtdResRec.kwh_shw     * Wt;
         kwh_ext     = kwh_ext     + WtdResRec.kwh_ext     * Wt;
         thm_tot     = thm_tot     + WtdResRec.thm_tot     * Wt;
         thm_equip   = thm_equip   + WtdResRec.thm_equip   * Wt;
         thm_htg     = thm_htg     + WtdResRec.thm_htg     * Wt;
         thm_shw     = thm_shw     + WtdResRec.thm_shw     * Wt;
         kwpp_tot    = kwpp_tot    + WtdResRec.kwpp_tot    * Wt;
         kwpp_ltg    = kwpp_ltg    + WtdResRec.kwpp_ltg    * Wt;
         kwpp_equip  = kwpp_equip  + WtdResRec.kwpp_equip  * Wt;
        END LOOP;
      INSERT INTO tech_results_wtd VALUES 
         (DEFAULT,TechResRec.techrefid,TechResRec.simqual,TechResRec.bldgtype,TechResRec.bldgvint,TechResRec.bldgloc,TechResRec.bldghvac,-1,TechResRec.normunit,
          round((numunits   /sumWt)::NUMERIC(15,3),2),
          round((measarea   /sumWt)::NUMERIC(15,1),2),
          round((kwh_tot    /sumWt)::NUMERIC(15,1),1),
          round((kwh_ltg    /sumWt)::NUMERIC(15,1),1),
          round((kwh_task   /sumWt)::NUMERIC(15,1),1),
          round((kwh_equip  /sumWt)::NUMERIC(15,1),1),
          round((kwh_htg    /sumWt)::NUMERIC(15,1),1),
          round((kwh_clg    /sumWt)::NUMERIC(15,1),1),
          round((kwh_twr    /sumWt)::NUMERIC(15,1),1),
          round((kwh_aux    /sumWt)::NUMERIC(15,1),1),
          round((kwh_vent   /sumWt)::NUMERIC(15,1),1),
          round((kwh_venthtg/sumWt)::NUMERIC(15,1),1),
          round((kwh_ventclg/sumWt)::NUMERIC(15,1),1),
          round((kwh_refg   /sumWt)::NUMERIC(15,1),1),
          round((kwh_hpsup  /sumWt)::NUMERIC(15,1),1),
          round((kwh_shw    /sumWt)::NUMERIC(15,1),1),
          round((kwh_ext    /sumWt)::NUMERIC(15,1),1),
          round((thm_tot    /sumWt)::NUMERIC(15,2),2),
          round((thm_equip  /sumWt)::NUMERIC(15,2),2),
          round((thm_htg    /sumWt)::NUMERIC(15,2),2),
          round((thm_shw    /sumWt)::NUMERIC(15,2),2),
          round((kwpp_tot   /sumWt)::NUMERIC(15,6),3),
          round((kwpp_ltg   /sumWt)::NUMERIC(15,6),3),
          round((kwpp_equip /sumWt)::NUMERIC(15,6),3)
          );
    ELSE
     -- Add record into wtd table indicating that weighted values could not be calculated
    INSERT INTO tech_results_wtd VALUES (DEFAULT,TechResRec.techrefid,TechResRec.simqual,TechResRec.bldgtype,TechResRec.bldgvint,TechResRec.bldgloc,TechResRec.bldghvac,-9,TechResRec.normunit,NumTstats,TechResRec.measarea);
  END IF;
END LOOP;
 RETURN TotProc;
END;
